/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk.byscroll;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollTask;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;

public class ParentBulkByScrollTask
extends BulkByScrollTask {
    private final AtomicArray<Tuple<BulkByScrollResponse, Exception>> results;
    private final AtomicInteger counter;

    public ParentBulkByScrollTask(long id, String type, String action, String description, TaskId parentTaskId, int slices) {
        super(id, type, action, description, parentTaskId);
        this.results = new AtomicArray(slices);
        this.counter = new AtomicInteger(slices);
    }

    @Override
    public void rethrottle(float newRequestsPerSecond) {
    }

    @Override
    public BulkByScrollTask.Status getStatus() {
        List<BulkByScrollTask.StatusOrException> statuses = Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]);
        this.addResultsToList(statuses);
        return new BulkByScrollTask.Status(Collections.unmodifiableList(statuses), this.getReasonCancelled());
    }

    @Override
    public int runningSliceSubTasks() {
        return this.counter.get();
    }

    @Override
    public TaskInfo getInfoGivenSliceInfo(String localNodeId, List<TaskInfo> sliceInfo) {
        List<BulkByScrollTask.StatusOrException> sliceStatuses = Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]);
        for (TaskInfo t : sliceInfo) {
            BulkByScrollTask.Status status = (BulkByScrollTask.Status)t.getStatus();
            sliceStatuses.set(status.getSliceId(), new BulkByScrollTask.StatusOrException(status));
        }
        this.addResultsToList(sliceStatuses);
        BulkByScrollTask.Status status = new BulkByScrollTask.Status(sliceStatuses, this.getReasonCancelled());
        return this.taskInfo(localNodeId, this.getDescription(), status);
    }

    private void addResultsToList(List<BulkByScrollTask.StatusOrException> sliceStatuses) {
        for (AtomicArray.Entry<Tuple<BulkByScrollResponse, Exception>> t : this.results.asList()) {
            if (t.value == null) continue;
            if (((Tuple)t.value).v1() != null) {
                sliceStatuses.set(t.index, new BulkByScrollTask.StatusOrException(((BulkByScrollResponse)((Tuple)t.value).v1()).getStatus()));
                continue;
            }
            sliceStatuses.set(t.index, new BulkByScrollTask.StatusOrException((Exception)((Tuple)t.value).v2()));
        }
    }

    public void onSliceResponse(ActionListener<BulkByScrollResponse> listener, int sliceId, BulkByScrollResponse response) {
        this.results.setOnce(sliceId, new Tuple<BulkByScrollResponse, Object>(response, null));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    void onSliceFailure(ActionListener<BulkByScrollResponse> listener, int sliceId, Exception e) {
        this.results.setOnce(sliceId, new Tuple<Object, Exception>(null, e));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    private void recordSliceCompletionAndRespondIfAllDone(ActionListener<BulkByScrollResponse> listener) {
        if (this.counter.decrementAndGet() != 0) {
            return;
        }
        ArrayList<BulkByScrollResponse> responses = new ArrayList<BulkByScrollResponse>(this.results.length());
        Exception exception = null;
        for (AtomicArray.Entry<Tuple<BulkByScrollResponse, Exception>> t : this.results.asList()) {
            if (((Tuple)t.value).v1() == null) {
                assert (((Tuple)t.value).v2() != null) : "exception shouldn't be null if value is null";
                if (exception == null) {
                    exception = (Exception)((Tuple)t.value).v2();
                    continue;
                }
                exception.addSuppressed((Throwable)((Tuple)t.value).v2());
                continue;
            }
            assert (((Tuple)t.value).v2() == null) : "exception should be null if response is not null";
            responses.add((BulkByScrollResponse)((Tuple)t.value).v1());
        }
        if (exception == null) {
            listener.onResponse(new BulkByScrollResponse(responses, this.getReasonCancelled()));
        } else {
            listener.onFailure(exception);
        }
    }
}

