/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.memory.MemoryIndex;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Automata;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class MemoryIndexOffsetStrategy
extends AnalysisOffsetStrategy {
    private final MemoryIndex memoryIndex;
    private final LeafReader leafReader;
    private final CharacterRunAutomaton preMemIndexFilterAutomaton;

    public MemoryIndexOffsetStrategy(String field, Predicate<String> fieldMatcher, BytesRef[] extractedTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata, Analyzer analyzer, Function<Query, Collection<Query>> multiTermQueryRewrite) {
        super(field, extractedTerms, phraseHelper, automata, analyzer);
        boolean storePayloads = phraseHelper.hasPositionSensitivity();
        this.memoryIndex = new MemoryIndex(true, storePayloads);
        this.leafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
        this.preMemIndexFilterAutomaton = MemoryIndexOffsetStrategy.buildCombinedAutomaton(fieldMatcher, this.terms, this.automata, phraseHelper, multiTermQueryRewrite);
    }

    private static CharacterRunAutomaton buildCombinedAutomaton(Predicate<String> fieldMatcher, BytesRef[] terms, CharacterRunAutomaton[] automata, PhraseHelper strictPhrases, Function<Query, Collection<Query>> multiTermQueryRewrite) {
        final ArrayList<CharacterRunAutomaton> allAutomata = new ArrayList<CharacterRunAutomaton>();
        if (terms.length > 0) {
            allAutomata.add(new CharacterRunAutomaton(Automata.makeStringUnion(Arrays.asList(terms))));
        }
        Collections.addAll(allAutomata, automata);
        for (SpanQuery spanQuery : strictPhrases.getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata(spanQuery, fieldMatcher, true, multiTermQueryRewrite));
        }
        if (allAutomata.size() == 1) {
            return (CharacterRunAutomaton)allAutomata.get(0);
        }
        return new CharacterRunAutomaton(Automata.makeEmpty()){

            @Override
            public boolean run(char[] chars, int offset, int length) {
                for (int i = 0; i < allAutomata.size(); ++i) {
                    if (!((CharacterRunAutomaton)allAutomata.get(i)).run(chars, offset, length)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public List<OffsetsEnum> getOffsetsEnums(IndexReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        tokenStream = MemoryIndexOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
        this.memoryIndex.reset();
        this.memoryIndex.addField(this.field, tokenStream);
        docId = 0;
        return this.createOffsetsEnumsFromReader(this.leafReader, docId);
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharacterRunAutomaton charRunAutomaton) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(x0);
                this.charAtt = this.addAttribute(CharTermAttribute.class);
            }

            @Override
            protected boolean accept() throws IOException {
                return charRunAutomaton.run(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }
}

