/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInvertState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.CollectionStatistics;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermStatistics;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.Similarity;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;

public class BooleanSimilarity
extends Similarity {
    private static final Similarity BM25_SIM = new BM25Similarity();

    @Override
    public long computeNorm(FieldInvertState state) {
        return BM25_SIM.computeNorm(state);
    }

    @Override
    public Similarity.SimWeight computeWeight(CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight();
    }

    @Override
    public Similarity.SimScorer simScorer(Similarity.SimWeight weight, LeafReaderContext context) throws IOException {
        final float boost = ((BooleanWeight)weight).boost;
        return new Similarity.SimScorer(){

            @Override
            public float score(int doc, float freq) {
                return boost;
            }

            @Override
            public Explanation explain(int doc, Explanation freq) {
                Explanation queryBoostExpl = Explanation.match(boost, "query boost", new Explanation[0]);
                return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + ", doc=" + doc + "), computed from:", queryBoostExpl);
            }

            @Override
            public float computeSlopFactor(int distance) {
                return 1.0f;
            }

            @Override
            public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
                return 1.0f;
            }
        };
    }

    private static class BooleanWeight
    extends Similarity.SimWeight {
        float boost = 1.0f;

        private BooleanWeight() {
        }

        @Override
        public void normalize(float queryNorm, float boost) {
            this.boost = boost;
        }

        @Override
        public float getValueForNormalization() {
            return this.boost * this.boost;
        }
    }
}

