/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.Axiomatic;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF1LOG
extends Axiomatic {
    public AxiomaticF1LOG(float s) {
        super(s);
    }

    public AxiomaticF1LOG() {
    }

    @Override
    public String toString() {
        return "F1LOG";
    }

    @Override
    protected float tf(BasicStats stats, float freq, float docLen) {
        if ((double)freq <= 0.0) {
            return 0.0f;
        }
        return (float)(1.0 + Math.log(1.0 + Math.log(freq)));
    }

    @Override
    protected float ln(BasicStats stats, float freq, float docLen) {
        return (stats.getAvgFieldLength() + this.s) / (stats.getAvgFieldLength() + docLen * this.s);
    }

    @Override
    protected float tfln(BasicStats stats, float freq, float docLen) {
        return 1.0f;
    }

    @Override
    protected float idf(BasicStats stats, float freq, float docLen) {
        return (float)Math.log(((double)stats.getNumberOfDocuments() + 1.0) / (double)stats.getDocFreq());
    }

    @Override
    protected float gamma(BasicStats stats, float freq, float docLen) {
        return 0.0f;
    }
}

