/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.DocValuesFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.NormsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.NormsFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.PointsFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.PointsWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.AbortingException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInvertState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NormValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PointValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermVectorsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsHash;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsHashPerField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.Similarity;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefHash;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.RamUsageEstimator;

final class DefaultIndexingChain
extends DocConsumer {
    final Counter bytesUsed;
    final DocumentsWriterPerThread.DocState docState;
    final DocumentsWriterPerThread docWriter;
    final FieldInfos.Builder fieldInfos;
    final TermsHash termsHash;
    private StoredFieldsWriter storedFieldsWriter;
    private int lastStoredDocID;
    private PerField[] fieldHash = new PerField[2];
    private int hashMask = 1;
    private int totalFieldCount;
    private long nextFieldGen;
    private PerField[] fields = new PerField[1];

    public DefaultIndexingChain(DocumentsWriterPerThread docWriter) throws IOException {
        this.docWriter = docWriter;
        this.fieldInfos = docWriter.getFieldInfosBuilder();
        this.docState = docWriter.docState;
        this.bytesUsed = docWriter.bytesUsed;
        TermVectorsConsumer termVectorsWriter = new TermVectorsConsumer(docWriter);
        this.termsHash = new FreqProxTermsWriter(docWriter, termVectorsWriter);
    }

    private void initStoredFieldsWriter() throws IOException {
        if (this.storedFieldsWriter == null) {
            this.storedFieldsWriter = this.docWriter.codec.storedFieldsFormat().fieldsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), IOContext.DEFAULT);
        }
    }

    @Override
    public void flush(SegmentWriteState state) throws IOException, AbortingException {
        int maxDoc = state.segmentInfo.maxDoc();
        long t0 = System.nanoTime();
        this.writeNorms(state);
        if (this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write norms");
        }
        t0 = System.nanoTime();
        this.writeDocValues(state);
        if (this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write docValues");
        }
        t0 = System.nanoTime();
        this.writePoints(state);
        if (this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write points");
        }
        t0 = System.nanoTime();
        this.initStoredFieldsWriter();
        this.fillStoredFields(maxDoc);
        this.storedFieldsWriter.finish(state.fieldInfos, maxDoc);
        this.storedFieldsWriter.close();
        if (this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to finish stored fields");
        }
        t0 = System.nanoTime();
        HashMap<String, TermsHashPerField> fieldsToFlush = new HashMap<String, TermsHashPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            PerField perField = this.fieldHash[i];
            while (perField != null) {
                if (perField.invertState != null) {
                    fieldsToFlush.put(perField.fieldInfo.name, perField.termsHashPerField);
                }
                perField = perField.next;
            }
        }
        this.termsHash.flush(fieldsToFlush, state);
        if (this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write postings and finish vectors");
        }
        t0 = System.nanoTime();
        this.docWriter.codec.fieldInfosFormat().write(state.directory, state.segmentInfo, "", state.fieldInfos, IOContext.DEFAULT);
        if (this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write fieldInfos");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePoints(SegmentWriteState state) throws IOException {
        block14: {
            PointsWriter pointsWriter;
            block13: {
                pointsWriter = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.pointValuesWriter != null) {
                                if (perField.fieldInfo.getPointDimensionCount() == 0) {
                                    throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has no points but wrote them"));
                                }
                                if (pointsWriter == null) {
                                    PointsFormat fmt = state.segmentInfo.getCodec().pointsFormat();
                                    if (fmt == null) {
                                        throw new IllegalStateException("field=\"" + perField.fieldInfo.name + "\" was indexed as points but codec does not support points");
                                    }
                                    pointsWriter = fmt.fieldsWriter(state);
                                }
                                perField.pointValuesWriter.flush(state, pointsWriter);
                                perField.pointValuesWriter = null;
                            } else if (perField.fieldInfo.getPointDimensionCount() != 0) {
                                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has points but did not write them"));
                            }
                            perField = perField.next;
                        }
                    }
                    if (pointsWriter != null) {
                        pointsWriter.finish();
                    }
                    if (!(success = true)) break block13;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(pointsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(pointsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(pointsWriter);
                break block14;
            }
            IOUtils.closeWhileHandlingException(pointsWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocValues(SegmentWriteState state) throws IOException {
        DocValuesConsumer dvConsumer;
        block16: {
            block15: {
                int maxDoc = state.segmentInfo.maxDoc();
                dvConsumer = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.docValuesWriter != null) {
                                if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                                    throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has no docValues but wrote them"));
                                }
                                if (dvConsumer == null) {
                                    DocValuesFormat fmt = state.segmentInfo.getCodec().docValuesFormat();
                                    dvConsumer = fmt.fieldsConsumer(state);
                                }
                                perField.docValuesWriter.finish(maxDoc);
                                perField.docValuesWriter.flush(state, dvConsumer);
                                perField.docValuesWriter = null;
                            } else if (perField.fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has docValues but did not write them"));
                            }
                            perField = perField.next;
                        }
                    }
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(dvConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(dvConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(dvConsumer);
                break block16;
            }
            IOUtils.closeWhileHandlingException(dvConsumer);
        }
        if (!state.fieldInfos.hasDocValues()) {
            if (dvConsumer != null) {
                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": fieldInfos has no docValues but wrote them"));
            }
        } else if (dvConsumer == null) {
            throw new AssertionError((Object)("segment=" + state.segmentInfo + ": fieldInfos has docValues but did not wrote them"));
        }
    }

    private void fillStoredFields(int docID) throws IOException, AbortingException {
        while (this.lastStoredDocID < docID) {
            this.startStoredFields();
            this.finishStoredFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNorms(SegmentWriteState state) throws IOException {
        block10: {
            NormsConsumer normsConsumer;
            block9: {
                boolean success = false;
                normsConsumer = null;
                try {
                    if (state.fieldInfos.hasNorms()) {
                        NormsFormat normsFormat = state.segmentInfo.getCodec().normsFormat();
                        assert (normsFormat != null);
                        normsConsumer = normsFormat.normsConsumer(state);
                        for (FieldInfo fi : state.fieldInfos) {
                            PerField perField = this.getPerField(fi.name);
                            assert (perField != null);
                            if (fi.omitsNorms() || fi.getIndexOptions() == IndexOptions.NONE) continue;
                            assert (perField.norms != null) : "field=" + fi.name;
                            perField.norms.finish(state.segmentInfo.maxDoc());
                            perField.norms.flush(state, normsConsumer);
                        }
                    }
                    if (!(success = true)) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(normsConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(normsConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(normsConsumer);
                break block10;
            }
            IOUtils.closeWhileHandlingException(normsConsumer);
        }
    }

    @Override
    public void abort() {
        IOUtils.closeWhileHandlingException(this.storedFieldsWriter);
        try {
            this.termsHash.abort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Arrays.fill(this.fieldHash, null);
    }

    private void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        assert (newHashSize > this.fieldHash.length);
        PerField[] newHashArray = new PerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (int j = 0; j < this.fieldHash.length; ++j) {
            PerField fp0 = this.fieldHash[j];
            while (fp0 != null) {
                int hashPos2 = fp0.fieldInfo.name.hashCode() & newHashMask;
                PerField nextFP0 = fp0.next;
                fp0.next = newHashArray[hashPos2];
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    private void startStoredFields() throws IOException, AbortingException {
        try {
            this.initStoredFieldsWriter();
            this.storedFieldsWriter.startDocument();
        }
        catch (Throwable th) {
            throw AbortingException.wrap(th);
        }
        ++this.lastStoredDocID;
    }

    private void finishStoredFields() throws IOException, AbortingException {
        try {
            this.storedFieldsWriter.finishDocument();
        }
        catch (Throwable th) {
            throw AbortingException.wrap(th);
        }
    }

    @Override
    public void processDocument() throws IOException, AbortingException {
        int fieldCount = 0;
        long fieldGen = this.nextFieldGen++;
        this.termsHash.startDocument();
        this.fillStoredFields(this.docState.docID);
        this.startStoredFields();
        boolean aborting = false;
        try {
            for (IndexableField indexableField : this.docState.doc) {
                fieldCount = this.processField(indexableField, fieldGen, fieldCount);
            }
        }
        catch (AbortingException ae) {
            aborting = true;
            throw ae;
        }
        finally {
            if (!aborting) {
                for (int i = 0; i < fieldCount; ++i) {
                    this.fields[i].finish();
                }
                this.finishStoredFields();
            }
        }
        try {
            this.termsHash.finishDocument();
        }
        catch (Throwable th) {
            throw AbortingException.wrap(th);
        }
    }

    private int processField(IndexableField field, long fieldGen, int fieldCount) throws IOException, AbortingException {
        DocValuesType dvType;
        String fieldName = field.name();
        IndexableFieldType fieldType = field.fieldType();
        PerField fp = null;
        if (fieldType.indexOptions() == null) {
            throw new NullPointerException("IndexOptions must not be null (field: \"" + field.name() + "\")");
        }
        if (fieldType.indexOptions() != IndexOptions.NONE) {
            if (fieldType.omitNorms() && field.boost() != 1.0f) {
                throw new UnsupportedOperationException("You cannot set an index-time boost: norms are omitted for field '" + field.name() + "'");
            }
            fp = this.getOrAddField(fieldName, fieldType, true);
            boolean first = fp.fieldGen != fieldGen;
            fp.invert(field, first);
            if (first) {
                this.fields[fieldCount++] = fp;
                fp.fieldGen = fieldGen;
            }
        } else {
            DefaultIndexingChain.verifyUnIndexedFieldType(fieldName, fieldType);
        }
        if (fieldType.stored()) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            if (fieldType.stored()) {
                String value = field.stringValue();
                if (value != null && value.length() > IndexWriter.MAX_STORED_STRING_LENGTH) {
                    throw new IllegalArgumentException("stored field \"" + field.name() + "\" is too large (" + value.length() + " characters) to store");
                }
                try {
                    this.storedFieldsWriter.writeField(fp.fieldInfo, field);
                }
                catch (Throwable th) {
                    throw AbortingException.wrap(th);
                }
            }
        }
        if ((dvType = fieldType.docValuesType()) == null) {
            throw new NullPointerException("docValuesType must not be null (field: \"" + fieldName + "\")");
        }
        if (dvType != DocValuesType.NONE) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            this.indexDocValue(fp, dvType, field);
        }
        if (fieldType.pointDimensionCount() != 0) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            this.indexPoint(fp, field);
        }
        return fieldCount;
    }

    private static void verifyUnIndexedFieldType(String name, IndexableFieldType ft) {
        if (ft.storeTermVectors()) {
            throw new IllegalArgumentException("cannot store term vectors for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPositions()) {
            throw new IllegalArgumentException("cannot store term vector positions for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorOffsets()) {
            throw new IllegalArgumentException("cannot store term vector offsets for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPayloads()) {
            throw new IllegalArgumentException("cannot store term vector payloads for a field that is not indexed (field=\"" + name + "\")");
        }
    }

    private void indexPoint(PerField fp, IndexableField field) throws IOException {
        int pointDimensionCount = field.fieldType().pointDimensionCount();
        int dimensionNumBytes = field.fieldType().pointNumBytes();
        if (fp.fieldInfo.getPointDimensionCount() == 0) {
            this.fieldInfos.globalFieldNumbers.setDimensions(fp.fieldInfo.number, fp.fieldInfo.name, pointDimensionCount, dimensionNumBytes);
        }
        fp.fieldInfo.setPointDimensions(pointDimensionCount, dimensionNumBytes);
        if (fp.pointValuesWriter == null) {
            fp.pointValuesWriter = new PointValuesWriter(this.docWriter, fp.fieldInfo);
        }
        fp.pointValuesWriter.addPackedValue(this.docState.docID, field.binaryValue());
    }

    private void indexDocValue(PerField fp, DocValuesType dvType, IndexableField field) throws IOException {
        if (fp.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
            this.fieldInfos.globalFieldNumbers.setDocValuesType(fp.fieldInfo.number, fp.fieldInfo.name, dvType);
        }
        fp.fieldInfo.setDocValuesType(dvType);
        int docID = this.docState.docID;
        switch (dvType) {
            case NUMERIC: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new NumericDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((NumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case BINARY: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new BinaryDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((BinaryDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED_NUMERIC: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedNumericDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedNumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case SORTED_SET: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedSetDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedSetDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + (Object)((Object)dvType)));
            }
        }
    }

    private PerField getPerField(String name) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldInfo.name.equals(name)) {
            fp = fp.next;
        }
        return fp;
    }

    private PerField getOrAddField(String name, IndexableFieldType fieldType, boolean invert) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldInfo.name.equals(name)) {
            fp = fp.next;
        }
        if (fp == null) {
            FieldInfo fi = this.fieldInfos.getOrAdd(name);
            fi.setIndexOptions(fieldType.indexOptions());
            fp = new PerField(fi, invert);
            fp.next = this.fieldHash[hashPos];
            this.fieldHash[hashPos] = fp;
            ++this.totalFieldCount;
            if (this.totalFieldCount >= this.fieldHash.length / 2) {
                this.rehash();
            }
            if (this.totalFieldCount > this.fields.length) {
                PerField[] newFields = new PerField[ArrayUtil.oversize(this.totalFieldCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.fields, 0, newFields, 0, this.fields.length);
                this.fields = newFields;
            }
        } else if (invert && fp.invertState == null) {
            fp.fieldInfo.setIndexOptions(fieldType.indexOptions());
            fp.setInvertState();
        }
        return fp;
    }

    private final class PerField
    implements Comparable<PerField> {
        final FieldInfo fieldInfo;
        final Similarity similarity;
        FieldInvertState invertState;
        TermsHashPerField termsHashPerField;
        DocValuesWriter docValuesWriter;
        PointValuesWriter pointValuesWriter;
        long fieldGen = -1L;
        PerField next;
        NormValuesWriter norms;
        TokenStream tokenStream;

        public PerField(FieldInfo fieldInfo, boolean invert) {
            this.fieldInfo = fieldInfo;
            this.similarity = DefaultIndexingChain.this.docState.similarity;
            if (invert) {
                this.setInvertState();
            }
        }

        void setInvertState() {
            this.invertState = new FieldInvertState(this.fieldInfo.name);
            this.termsHashPerField = DefaultIndexingChain.this.termsHash.addField(this.invertState, this.fieldInfo);
            if (!this.fieldInfo.omitsNorms()) {
                assert (this.norms == null);
                this.norms = new NormValuesWriter(this.fieldInfo, DefaultIndexingChain.this.docState.docWriter.bytesUsed);
            }
        }

        @Override
        public int compareTo(PerField other) {
            return this.fieldInfo.name.compareTo(other.fieldInfo.name);
        }

        public void finish() throws IOException {
            if (!this.fieldInfo.omitsNorms() && this.invertState.length != 0) {
                this.norms.addValue(DefaultIndexingChain.this.docState.docID, this.similarity.computeNorm(this.invertState));
            }
            this.termsHashPerField.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invert(IndexableField field, boolean first) throws IOException, AbortingException {
            if (first) {
                this.invertState.reset();
            }
            IndexableFieldType fieldType = field.fieldType();
            IndexOptions indexOptions = fieldType.indexOptions();
            this.fieldInfo.setIndexOptions(indexOptions);
            if (fieldType.omitNorms()) {
                this.fieldInfo.setOmitsNorms();
            }
            boolean analyzed = fieldType.tokenized() && DefaultIndexingChain.this.docState.analyzer != null;
            boolean checkOffsets = indexOptions == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            boolean succeededInProcessingField = false;
            try (TokenStream stream = this.tokenStream = field.tokenStream(DefaultIndexingChain.this.docState.analyzer, this.tokenStream);){
                stream.reset();
                this.invertState.setAttributeSource(stream);
                this.termsHashPerField.start(field, first);
                while (stream.incrementToken()) {
                    int posIncr = this.invertState.posIncrAttribute.getPositionIncrement();
                    this.invertState.position += posIncr;
                    if (this.invertState.position < this.invertState.lastPosition) {
                        if (posIncr == 0) {
                            throw new IllegalArgumentException("first position increment must be > 0 (got 0) for field '" + field.name() + "'");
                        }
                        if (posIncr < 0) {
                            throw new IllegalArgumentException("position increment must be >= 0 (got " + posIncr + ") for field '" + field.name() + "'");
                        }
                        throw new IllegalArgumentException("position overflowed Integer.MAX_VALUE (got posIncr=" + posIncr + " lastPosition=" + this.invertState.lastPosition + " position=" + this.invertState.position + ") for field '" + field.name() + "'");
                    }
                    if (this.invertState.position > 0x7FFFFF7F) {
                        throw new IllegalArgumentException("position " + this.invertState.position + " is too large for field '" + field.name() + "': max allowed position is " + 0x7FFFFF7F);
                    }
                    this.invertState.lastPosition = this.invertState.position;
                    if (posIncr == 0) {
                        ++this.invertState.numOverlap;
                    }
                    if (checkOffsets) {
                        int startOffset = this.invertState.offset + this.invertState.offsetAttribute.startOffset();
                        int endOffset = this.invertState.offset + this.invertState.offsetAttribute.endOffset();
                        if (startOffset < this.invertState.lastStartOffset || endOffset < startOffset) {
                            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, and offsets must not go backwards startOffset=" + startOffset + ",endOffset=" + endOffset + ",lastStartOffset=" + this.invertState.lastStartOffset + " for field '" + field.name() + "'");
                        }
                        this.invertState.lastStartOffset = startOffset;
                    }
                    ++this.invertState.length;
                    if (this.invertState.length < 0) {
                        throw new IllegalArgumentException("too many tokens in field '" + field.name() + "'");
                    }
                    try {
                        this.termsHashPerField.add();
                    }
                    catch (BytesRefHash.MaxBytesLengthExceededException e) {
                        byte[] prefix = new byte[30];
                        BytesRef bigTerm = this.invertState.termAttribute.getBytesRef();
                        System.arraycopy(bigTerm.bytes, bigTerm.offset, prefix, 0, 30);
                        String msg = "Document contains at least one immense term in field=\"" + this.fieldInfo.name + "\" (whose UTF8 encoding is longer than the max length " + 32766 + "), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...', original message: " + e.getMessage();
                        if (DefaultIndexingChain.this.docState.infoStream.isEnabled("IW")) {
                            DefaultIndexingChain.this.docState.infoStream.message("IW", "ERROR: " + msg);
                        }
                        throw new IllegalArgumentException(msg, e);
                    }
                    catch (Throwable th) {
                        throw AbortingException.wrap(th);
                    }
                }
                stream.end();
                this.invertState.position += this.invertState.posIncrAttribute.getPositionIncrement();
                this.invertState.offset += this.invertState.offsetAttribute.endOffset();
                succeededInProcessingField = true;
            }
            finally {
                if (!succeededInProcessingField && DefaultIndexingChain.this.docState.infoStream.isEnabled("DW")) {
                    DefaultIndexingChain.this.docState.infoStream.message("DW", "An exception was thrown while processing field " + this.fieldInfo.name);
                }
            }
            if (analyzed) {
                this.invertState.position += DefaultIndexingChain.this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name);
                this.invertState.offset += DefaultIndexingChain.this.docState.analyzer.getOffsetGap(this.fieldInfo.name);
            }
            this.invertState.boost *= field.boost();
        }
    }
}

