/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.synonym;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.util.TokenizerFactory;

@Deprecated
public class SynonymFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private final boolean ignoreCase;
    private final String tokenizerFactory;
    private final String synonyms;
    private final String format;
    private final boolean expand;
    private final String analyzerName;
    private final Map<String, String> tokArgs = new HashMap<String, String>();
    private SynonymMap map;

    public SynonymFilterFactory(Map<String, String> args) {
        super(args);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        this.synonyms = this.require(args, "synonyms");
        this.format = this.get(args, "format");
        this.expand = this.getBoolean(args, "expand", true);
        this.analyzerName = this.get(args, "analyzer");
        this.tokenizerFactory = this.get(args, "tokenizerFactory");
        if (this.analyzerName != null && this.tokenizerFactory != null) {
            throw new IllegalArgumentException("Analyzer and TokenizerFactory can't be specified both: " + this.analyzerName + " and " + this.tokenizerFactory);
        }
        if (this.tokenizerFactory != null) {
            this.tokArgs.put("luceneMatchVersion", this.getLuceneMatchVersion().toString());
            Iterator<String> itr = args.keySet().iterator();
            while (itr.hasNext()) {
                String key = itr.next();
                this.tokArgs.put(key.replaceAll("^tokenizerFactory\\.", ""), args.get(key));
                itr.remove();
            }
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.map.fst == null ? input : new SynonymFilter(input, this.map, this.ignoreCase);
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        final TokenizerFactory factory = this.tokenizerFactory == null ? null : this.loadTokenizerFactory(loader, this.tokenizerFactory);
        Analyzer analyzer = this.analyzerName != null ? this.loadAnalyzer(loader, this.analyzerName) : new Analyzer(){

            @Override
            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                Tokenizer tokenizer = factory == null ? new WhitespaceTokenizer() : factory.create();
                TokenStream stream = SynonymFilterFactory.this.ignoreCase ? new LowerCaseFilter(tokenizer) : tokenizer;
                return new Analyzer.TokenStreamComponents(tokenizer, stream);
            }
        };
        try (Analyzer a = analyzer;){
            String formatClass = this.format;
            if (this.format == null || this.format.equals("solr")) {
                formatClass = SolrSynonymParser.class.getName();
            } else if (this.format.equals("wordnet")) {
                formatClass = WordnetSynonymParser.class.getName();
            }
            this.map = this.loadSynonyms(loader, formatClass, true, a);
        }
        catch (ParseException e) {
            throw new IOException("Error parsing synonyms file:", e);
        }
    }

    protected SynonymMap loadSynonyms(ResourceLoader loader, String cname, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
        SynonymMap.Parser parser;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        Class<SynonymMap.Parser> clazz = loader.findClass(cname, SynonymMap.Parser.class);
        try {
            parser = clazz.getConstructor(Boolean.TYPE, Boolean.TYPE, Analyzer.class).newInstance(dedup, this.expand, analyzer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<String> files = this.splitFileNames(this.synonyms);
        for (String file : files) {
            decoder.reset();
            InputStreamReader isr = new InputStreamReader(loader.openResource(file), decoder);
            Throwable throwable = null;
            try {
                parser.parse(isr);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (isr == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)isr).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)isr).close();
            }
        }
        return parser.build();
    }

    private TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname) throws IOException {
        Class<TokenizerFactory> clazz = loader.findClass(cname, TokenizerFactory.class);
        try {
            TokenizerFactory tokFactory = clazz.getConstructor(Map.class).newInstance(this.tokArgs);
            if (tokFactory instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)((Object)tokFactory)).inform(loader);
            }
            return tokFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Analyzer loadAnalyzer(ResourceLoader loader, String cname) throws IOException {
        Class<Analyzer> clazz = loader.findClass(cname, Analyzer.class);
        try {
            Analyzer analyzer = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (analyzer instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)((Object)analyzer)).inform(loader);
            }
            return analyzer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

