/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.ro;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.StopFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.tartarus.snowball.ext.RomanianStemmer;

public final class RomanianAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public RomanianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public RomanianAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public RomanianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new StandardFilter(source);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SnowballFilter((TokenStream)result, new RomanianStemmer());
        return new Analyzer.TokenStreamComponents(source, result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new StandardFilter(in);
        result = new LowerCaseFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = RomanianAnalyzer.loadStopwordSet(false, RomanianAnalyzer.class, RomanianAnalyzer.DEFAULT_STOPWORD_FILE, RomanianAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

