/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.win32;

import java.lang.reflect.Method;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.FunctionMapper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.Native;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.NativeLibrary;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.NativeMapped;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.NativeMappedConverter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.Pointer;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls.isArray()) {
            return Pointer.SIZE;
        }
        try {
            return Native.getNativeSize(cls);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
        }
    }

    @Override
    public String getFunctionName(NativeLibrary library, Method method) {
        String name = method.getName();
        int pop = 0;
        Class<?>[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            pop += this.getArgumentNativeStackSize(argTypes[i]);
        }
        String decorated = name + "@" + pop;
        int conv = 63;
        try {
            name = library.getFunction(decorated, conv).getName();
        }
        catch (UnsatisfiedLinkError e) {
            try {
                name = library.getFunction("_" + decorated, conv).getName();
            }
            catch (UnsatisfiedLinkError e2) {
                // empty catch block
            }
        }
        return name;
    }
}

