/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.reflect.guards;

import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.ObjectHandler;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.reflect.Guard;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.reflect.ReflectionObjectHandler;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.util.Wrapper;

public class WrappedGuard
implements Guard {
    protected final ObjectHandler oh;
    protected final int index;
    protected final Wrapper[] wrappers;
    private final List<Guard> wrapperGuard;

    public WrappedGuard(ObjectHandler oh, int index, List<Wrapper> wrappers, List<Guard> wrapperGuard) {
        this.oh = oh;
        this.index = index;
        this.wrappers = wrappers.toArray(new Wrapper[wrappers.size()]);
        this.wrapperGuard = wrapperGuard;
    }

    @Override
    public boolean apply(List<Object> objects) {
        Object scope = ReflectionObjectHandler.unwrap(this.oh, this.index, this.wrappers, objects);
        for (Guard predicate : this.wrapperGuard) {
            if (predicate.apply(ObjectHandler.makeList(scope))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[WrappedGuard: " + this.index + " " + this.wrapperGuard + "]";
    }
}

