/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.elasticsearch.ActionRequestFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchOptions;
import org.apache.flink.streaming.connectors.elasticsearch.util.IgnoringFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.util.NoOpFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.util.RetryRejectedExecutionFailureHandler;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.util.InstantiationUtil;

@Internal
class ElasticsearchConfiguration {
    protected final ReadableConfig config;
    private final ClassLoader classLoader;

    ElasticsearchConfiguration(ReadableConfig config, ClassLoader classLoader) {
        this.config = config;
        this.classLoader = classLoader;
    }

    public ActionRequestFailureHandler getFailureHandler() {
        ActionRequestFailureHandler failureHandler;
        String value = (String)this.config.get(ElasticsearchOptions.FAILURE_HANDLER_OPTION);
        switch (value.toUpperCase()) {
            case "FAIL": {
                failureHandler = new NoOpFailureHandler();
                break;
            }
            case "IGNORE": {
                failureHandler = new IgnoringFailureHandler();
                break;
            }
            case "RETRY-REJECTED": {
                failureHandler = new RetryRejectedExecutionFailureHandler();
                break;
            }
            default: {
                try {
                    Class<?> failureHandlerClass = Class.forName(value, false, this.classLoader);
                    failureHandler = (ActionRequestFailureHandler)InstantiationUtil.instantiate(failureHandlerClass);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Could not instantiate the failure handler class: " + value, (Throwable)e);
                }
            }
        }
        return failureHandler;
    }

    public String getDocumentType() {
        return (String)this.config.get(ElasticsearchOptions.DOCUMENT_TYPE_OPTION);
    }

    public int getBulkFlushMaxActions() {
        int maxActions = (Integer)this.config.get(ElasticsearchOptions.BULK_FLUSH_MAX_ACTIONS_OPTION);
        return maxActions == 0 ? -1 : maxActions;
    }

    public long getBulkFlushMaxByteSize() {
        long maxSize = ((MemorySize)this.config.get(ElasticsearchOptions.BULK_FLASH_MAX_SIZE_OPTION)).getBytes();
        return maxSize == 0L ? -1L : maxSize;
    }

    public long getBulkFlushInterval() {
        long interval = ((Duration)this.config.get(ElasticsearchOptions.BULK_FLUSH_INTERVAL_OPTION)).toMillis();
        return interval == 0L ? -1L : interval;
    }

    public boolean isBulkFlushBackoffEnabled() {
        return this.config.get(ElasticsearchOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION) != ElasticsearchOptions.BackOffType.DISABLED;
    }

    public Optional<ElasticsearchSinkBase.FlushBackoffType> getBulkFlushBackoffType() {
        switch ((ElasticsearchOptions.BackOffType)((Object)this.config.get(ElasticsearchOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION))) {
            case CONSTANT: {
                return Optional.of(ElasticsearchSinkBase.FlushBackoffType.CONSTANT);
            }
            case EXPONENTIAL: {
                return Optional.of(ElasticsearchSinkBase.FlushBackoffType.EXPONENTIAL);
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getBulkFlushBackoffRetries() {
        return this.config.getOptional(ElasticsearchOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION);
    }

    public Optional<Long> getBulkFlushBackoffDelay() {
        return this.config.getOptional(ElasticsearchOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION).map(Duration::toMillis);
    }

    public boolean isDisableFlushOnCheckpoint() {
        return (Boolean)this.config.get(ElasticsearchOptions.FLUSH_ON_CHECKPOINT_OPTION) == false;
    }

    public String getIndex() {
        return (String)this.config.get(ElasticsearchOptions.INDEX_OPTION);
    }

    public String getKeyDelimiter() {
        return (String)this.config.get(ElasticsearchOptions.KEY_DELIMITER_OPTION);
    }

    public Optional<String> getPathPrefix() {
        return this.config.getOptional(ElasticsearchOptions.CONNECTION_PATH_PREFIX);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchConfiguration that = (ElasticsearchConfiguration)o;
        return Objects.equals(this.config, that.config) && Objects.equals(this.classLoader, that.classLoader);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.classLoader);
    }
}

