/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.examples;

import java.util.HashMap;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.shaded.com.google.common.collect.Maps;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSink;
import org.apache.flink.streaming.connectors.elasticsearch.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Requests;

public class ElasticsearchExample {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.addSource((SourceFunction)new SourceFunction<String>(){
            private static final long serialVersionUID = 1L;
            private volatile boolean running = true;

            public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
                for (int i = 0; i < 20 && this.running; ++i) {
                    ctx.collect((Object)("message #" + i));
                }
            }

            public void cancel() {
                this.running = false;
            }
        });
        HashMap<String, String> config = Maps.newHashMap();
        config.put("bulk.flush.max.actions", "1");
        source.addSink(new ElasticsearchSink<String>(config, new IndexRequestBuilder<String>(){

            @Override
            public IndexRequest createIndexRequest(String element, RuntimeContext ctx) {
                HashMap<String, String> json = new HashMap<String, String>();
                json.put("data", element);
                return ((IndexRequest)Requests.indexRequest().index("my-index")).type("my-type").source(json);
            }
        }));
        env.execute("Elasticsearch Example");
    }
}

