/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.util.NoOpFailureHandler;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.descriptors.Elasticsearch;
import org.apache.flink.table.descriptors.ElasticsearchValidator;
import org.junit.Test;

public class ElasticsearchTest
extends DescriptorTestBase {
    @Test(expected=ValidationException.class)
    public void testMissingIndex() {
        this.removePropertyAndVerify(this.descriptors().get(0), "connector.index");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidFailureHandler() {
        this.addPropertyAndVerify(this.descriptors().get(0), "connector.failure-handler", "invalid handler");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidMemorySize() {
        this.addPropertyAndVerify(this.descriptors().get(1), "connector.bulk-flush.max-size", "12 bytes");
    }

    public List<Descriptor> descriptors() {
        Elasticsearch minimumDesc = new Elasticsearch().version("6").host("localhost", 1234, "http").index("MyIndex").documentType("MyType");
        Elasticsearch maximumDesc = new Elasticsearch().version("6").host("host1", 1234, "https").host("host2", 1234, "https").index("MyIndex").documentType("MyType").keyDelimiter("#").keyNullLiteral("").bulkFlushBackoffExponential().bulkFlushBackoffDelay(123L).bulkFlushBackoffMaxRetries(3).bulkFlushInterval(100L).bulkFlushMaxActions(1000).bulkFlushMaxSize("12 MB").failureHandlerRetryRejected().connectionMaxRetryTimeout(100).connectionPathPrefix("/myapp");
        Elasticsearch customDesc = new Elasticsearch().version("6").host("localhost", 1234, "http").index("MyIndex").documentType("MyType").disableFlushOnCheckpoint().failureHandlerCustom(NoOpFailureHandler.class);
        return Arrays.asList(minimumDesc, maximumDesc, customDesc);
    }

    public List<Map<String, String>> properties() {
        HashMap<String, String> minimumDesc = new HashMap<String, String>();
        minimumDesc.put("connector.property-version", "1");
        minimumDesc.put("connector.type", "elasticsearch");
        minimumDesc.put("connector.version", "6");
        minimumDesc.put("connector.hosts.0.hostname", "localhost");
        minimumDesc.put("connector.hosts.0.port", "1234");
        minimumDesc.put("connector.hosts.0.protocol", "http");
        minimumDesc.put("connector.index", "MyIndex");
        minimumDesc.put("connector.document-type", "MyType");
        HashMap<String, String> maximumDesc = new HashMap<String, String>();
        maximumDesc.put("connector.property-version", "1");
        maximumDesc.put("connector.type", "elasticsearch");
        maximumDesc.put("connector.version", "6");
        maximumDesc.put("connector.hosts.0.hostname", "host1");
        maximumDesc.put("connector.hosts.0.port", "1234");
        maximumDesc.put("connector.hosts.0.protocol", "https");
        maximumDesc.put("connector.hosts.1.hostname", "host2");
        maximumDesc.put("connector.hosts.1.port", "1234");
        maximumDesc.put("connector.hosts.1.protocol", "https");
        maximumDesc.put("connector.index", "MyIndex");
        maximumDesc.put("connector.document-type", "MyType");
        maximumDesc.put("connector.key-delimiter", "#");
        maximumDesc.put("connector.key-null-literal", "");
        maximumDesc.put("connector.bulk-flush.backoff.type", "exponential");
        maximumDesc.put("connector.bulk-flush.backoff.delay", "123");
        maximumDesc.put("connector.bulk-flush.backoff.max-retries", "3");
        maximumDesc.put("connector.bulk-flush.interval", "100");
        maximumDesc.put("connector.bulk-flush.max-actions", "1000");
        maximumDesc.put("connector.bulk-flush.max-size", "12582912 bytes");
        maximumDesc.put("connector.failure-handler", "retry-rejected");
        maximumDesc.put("connector.connection-max-retry-timeout", "100");
        maximumDesc.put("connector.connection-path-prefix", "/myapp");
        HashMap<String, String> customDesc = new HashMap<String, String>();
        customDesc.put("connector.property-version", "1");
        customDesc.put("connector.type", "elasticsearch");
        customDesc.put("connector.version", "6");
        customDesc.put("connector.hosts.0.hostname", "localhost");
        customDesc.put("connector.hosts.0.port", "1234");
        customDesc.put("connector.hosts.0.protocol", "http");
        customDesc.put("connector.index", "MyIndex");
        customDesc.put("connector.document-type", "MyType");
        customDesc.put("connector.flush-on-checkpoint", "false");
        customDesc.put("connector.failure-handler", "custom");
        customDesc.put("connector.failure-handler-class", NoOpFailureHandler.class.getName());
        return Arrays.asList(minimumDesc, maximumDesc, customDesc);
    }

    public DescriptorValidator validator() {
        return new ElasticsearchValidator();
    }
}

