/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.EmbeddedElasticsearchNodeEnvironment;
import org.apache.flink.streaming.connectors.elasticsearch.testutils.SourceSinkDataTestKit;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.util.InstantiationUtil;
import org.elasticsearch.client.Client;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticsearchSinkTestBase<C extends AutoCloseable, A>
extends AbstractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchSinkTestBase.class);
    protected static final String CLUSTER_NAME = "test-cluster";
    protected static EmbeddedElasticsearchNodeEnvironment embeddedNodeEnv;
    @ClassRule
    public static TemporaryFolder tempFolder;

    @BeforeClass
    public static void prepare() throws Exception {
        LOG.info("-------------------------------------------------------------------------");
        LOG.info("    Starting embedded Elasticsearch node ");
        LOG.info("-------------------------------------------------------------------------");
        Class<?> clazz = Class.forName("org.apache.flink.streaming.connectors.elasticsearch.EmbeddedElasticsearchNodeEnvironmentImpl");
        embeddedNodeEnv = (EmbeddedElasticsearchNodeEnvironment)InstantiationUtil.instantiate(clazz);
        embeddedNodeEnv.start(tempFolder.newFolder(), CLUSTER_NAME);
    }

    @AfterClass
    public static void shutdown() throws Exception {
        LOG.info("-------------------------------------------------------------------------");
        LOG.info("    Shutting down embedded Elasticsearch node ");
        LOG.info("-------------------------------------------------------------------------");
        embeddedNodeEnv.close();
    }

    public void runElasticsearchSinkTest() throws Exception {
        String index = "elasticsearch-sink-test-index";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.addSource((SourceFunction)new SourceSinkDataTestKit.TestDataSourceFunction());
        source.addSink(this.createElasticsearchSinkForEmbeddedNode(1, CLUSTER_NAME, new SourceSinkDataTestKit.TestElasticsearchSinkFunction("elasticsearch-sink-test-index")));
        env.execute("Elasticsearch Sink Test");
        Client client = embeddedNodeEnv.getClient();
        SourceSinkDataTestKit.verifyProducedSinkData(client, "elasticsearch-sink-test-index");
        client.close();
    }

    public void runNullAddressesTest() throws Exception {
        HashMap<String, String> userConfig = new HashMap<String, String>();
        userConfig.put("bulk.flush.max.actions", "1");
        userConfig.put("cluster.name", CLUSTER_NAME);
        try {
            this.createElasticsearchSink(1, CLUSTER_NAME, null, new SourceSinkDataTestKit.TestElasticsearchSinkFunction("test"));
        }
        catch (IllegalArgumentException | NullPointerException expectedException) {
            return;
        }
        Assert.fail();
    }

    public void runEmptyAddressesTest() throws Exception {
        HashMap<String, String> userConfig = new HashMap<String, String>();
        userConfig.put("bulk.flush.max.actions", "1");
        userConfig.put("cluster.name", CLUSTER_NAME);
        try {
            this.createElasticsearchSink(1, CLUSTER_NAME, Collections.emptyList(), new SourceSinkDataTestKit.TestElasticsearchSinkFunction("test"));
        }
        catch (IllegalArgumentException expectedException) {
            return;
        }
        Assert.fail();
    }

    public void runInvalidElasticsearchClusterTest() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.addSource((SourceFunction)new SourceSinkDataTestKit.TestDataSourceFunction());
        HashMap<String, String> userConfig = new HashMap<String, String>();
        userConfig.put("bulk.flush.max.actions", "1");
        userConfig.put("cluster.name", "invalid-cluster-name");
        source.addSink(this.createElasticsearchSinkForNode(1, "invalid-cluster-name", new SourceSinkDataTestKit.TestElasticsearchSinkFunction("test"), "123.123.123.123"));
        try {
            env.execute("Elasticsearch Sink Test");
        }
        catch (JobExecutionException expectedException) {
            return;
        }
        Assert.fail();
    }

    protected Map<String, String> createUserConfig(int bulkFlushMaxActions, String clusterName) {
        HashMap<String, String> userConfig = new HashMap<String, String>();
        userConfig.put("cluster.name", clusterName);
        userConfig.put("bulk.flush.max.actions", String.valueOf(bulkFlushMaxActions));
        return userConfig;
    }

    protected abstract ElasticsearchSinkBase<Tuple2<Integer, String>, C> createElasticsearchSink(int var1, String var2, List<A> var3, ElasticsearchSinkFunction<Tuple2<Integer, String>> var4);

    protected abstract ElasticsearchSinkBase<Tuple2<Integer, String>, C> createElasticsearchSinkForEmbeddedNode(int var1, String var2, ElasticsearchSinkFunction<Tuple2<Integer, String>> var3) throws Exception;

    protected abstract ElasticsearchSinkBase<Tuple2<Integer, String>, C> createElasticsearchSinkForNode(int var1, String var2, ElasticsearchSinkFunction<Tuple2<Integer, String>> var3, String var4) throws Exception;

    static {
        tempFolder = new TemporaryFolder();
    }
}

