/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.apache.flink.util.Preconditions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkProcessor;

class BulkProcessorIndexer
implements RequestIndexer {
    private static final long serialVersionUID = 6841162943062034253L;
    private final BulkProcessor bulkProcessor;
    private final boolean flushOnCheckpoint;
    private final AtomicLong numPendingRequestsRef;

    BulkProcessorIndexer(BulkProcessor bulkProcessor, boolean flushOnCheckpoint, AtomicLong numPendingRequestsRef) {
        this.bulkProcessor = (BulkProcessor)Preconditions.checkNotNull((Object)bulkProcessor);
        this.flushOnCheckpoint = flushOnCheckpoint;
        this.numPendingRequestsRef = (AtomicLong)Preconditions.checkNotNull((Object)numPendingRequestsRef);
    }

    @Override
    public void add(ActionRequest ... actionRequests) {
        for (ActionRequest actionRequest : actionRequests) {
            if (this.flushOnCheckpoint) {
                this.numPendingRequestsRef.getAndIncrement();
            }
            this.bulkProcessor.add(actionRequest);
        }
    }
}

