/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.testutils;

import org.apache.flink.streaming.connectors.elasticsearch.EmbeddedElasticsearchNodeEnvironment;
import org.apache.flink.util.InstantiationUtil;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.common.unit.TimeValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchResource
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchResource.class);
    private EmbeddedElasticsearchNodeEnvironment embeddedNodeEnv;
    private final TemporaryFolder tempFolder = new TemporaryFolder();
    private final String clusterName;

    public ElasticsearchResource(String clusterName) {
        this.clusterName = clusterName;
    }

    protected void before() throws Throwable {
        LOG.info("-------------------------------------------------------------------------");
        LOG.info("    Starting embedded Elasticsearch node ");
        LOG.info("-------------------------------------------------------------------------");
        Class<?> clazz = Class.forName("org.apache.flink.streaming.connectors.elasticsearch.EmbeddedElasticsearchNodeEnvironmentImpl");
        this.embeddedNodeEnv = (EmbeddedElasticsearchNodeEnvironment)InstantiationUtil.instantiate(clazz);
        this.tempFolder.create();
        this.embeddedNodeEnv.start(this.tempFolder.newFolder(), this.clusterName);
        this.waitForCluster();
    }

    private void waitForCluster() {
        AdminClient adminClient = this.embeddedNodeEnv.getClient().admin();
        ClusterAdminClient clusterAdminClient = adminClient.cluster();
        ClusterHealthRequestBuilder requestBuilder = clusterAdminClient.prepareHealth(new String[]{"_all"});
        requestBuilder = requestBuilder.setTimeout(TimeValue.timeValueSeconds((long)120L));
        ActionFuture healthFuture = clusterAdminClient.health((ClusterHealthRequest)requestBuilder.request());
        ClusterHealthResponse health = (ClusterHealthResponse)healthFuture.actionGet(TimeValue.timeValueSeconds((long)120L));
        Assert.assertThat((Object)health.getNumberOfNodes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)health.getNumberOfDataNodes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    protected void after() {
        LOG.info("-------------------------------------------------------------------------");
        LOG.info("    Shutting down embedded Elasticsearch node ");
        LOG.info("-------------------------------------------------------------------------");
        try {
            this.embeddedNodeEnv.close();
            this.tempFolder.delete();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Client getClient() {
        return this.embeddedNodeEnv.getClient();
    }
}

