/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.elasticsearch.table.KeyExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class KeyExtractorTest {
    @Test
    public void testSimpleKey() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.BIGINT().notNull()).field("b", DataTypes.STRING()).primaryKey(new String[]{"a"}).build();
        Function keyExtractor = KeyExtractor.createKeyExtractor((TableSchema)schema, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{12L, StringData.fromString((String)"ABCD")}));
        Assert.assertThat((Object)key, (Matcher)CoreMatchers.equalTo((Object)"12"));
    }

    @Test
    public void testNoPrimaryKey() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.BIGINT().notNull()).field("b", DataTypes.STRING()).build();
        Function keyExtractor = KeyExtractor.createKeyExtractor((TableSchema)schema, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{12L, StringData.fromString((String)"ABCD")}));
        Assert.assertThat((Object)key, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testTwoFieldsKey() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.BIGINT().notNull()).field("b", DataTypes.STRING()).field("c", (DataType)DataTypes.TIMESTAMP().notNull()).primaryKey(new String[]{"a", "c"}).build();
        Function keyExtractor = KeyExtractor.createKeyExtractor((TableSchema)schema, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{12L, StringData.fromString((String)"ABCD"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2012-12-12T12:12:12"))}));
        Assert.assertThat((Object)key, (Matcher)CoreMatchers.equalTo((Object)"12_2012-12-12T12:12:12"));
    }

    @Test
    public void testAllTypesKey() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.TINYINT().notNull()).field("b", (DataType)DataTypes.SMALLINT().notNull()).field("c", (DataType)DataTypes.INT().notNull()).field("d", (DataType)DataTypes.BIGINT().notNull()).field("e", (DataType)DataTypes.BOOLEAN().notNull()).field("f", (DataType)DataTypes.FLOAT().notNull()).field("g", (DataType)DataTypes.DOUBLE().notNull()).field("h", (DataType)DataTypes.STRING().notNull()).field("i", (DataType)DataTypes.TIMESTAMP().notNull()).field("j", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull()).field("k", (DataType)DataTypes.TIME().notNull()).field("l", (DataType)DataTypes.DATE().notNull()).primaryKey(new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"}).build();
        Function keyExtractor = KeyExtractor.createKeyExtractor((TableSchema)schema, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{(byte)1, (short)2, 3, 4L, true, Float.valueOf(1.0f), 2.0, StringData.fromString((String)"ABCD"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2012-12-12T12:12:12")), TimestampData.fromInstant((Instant)Instant.parse("2013-01-13T13:13:13Z")), (int)(LocalTime.parse("14:14:14").toNanoOfDay() / 1000000L), (int)LocalDate.parse("2015-05-15").toEpochDay()}));
        Assert.assertThat((Object)key, (Matcher)CoreMatchers.equalTo((Object)"1_2_3_4_true_1.0_2.0_ABCD_2012-12-12T12:12:12_2013-01-13T13:13:13_14:14:14_2015-05-15"));
    }
}

