/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGeneratorFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexGeneratorFactoryTest
extends TestLogger {
    private TableSchema schema;
    private List<RowData> rows;

    @Before
    public void prepareData() {
        this.schema = new TableSchema.Builder().field("id", DataTypes.INT()).field("item", DataTypes.STRING()).field("log_ts", DataTypes.BIGINT()).field("log_date", DataTypes.DATE()).field("log_time", DataTypes.TIME()).field("order_timestamp", DataTypes.TIMESTAMP()).field("local_timestamp", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()).field("status", DataTypes.BOOLEAN()).build();
        this.rows = new ArrayList<RowData>();
        this.rows.add((RowData)GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"apple"), Timestamp.valueOf("2020-03-18 12:12:14").getTime(), (int)LocalDate.parse("2020-03-18").toEpochDay(), (int)(LocalTime.parse("12:12:14").toNanoOfDay() / 1000000L), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2020-03-18T12:12:14")), TimestampData.fromInstant((Instant)Instant.parse("2020-03-18T12:12:14Z")), true}));
        this.rows.add((RowData)GenericRowData.of((Object[])new Object[]{2, StringData.fromString((String)"peanut"), Timestamp.valueOf("2020-03-19 12:12:14").getTime(), (int)LocalDate.parse("2020-03-19").toEpochDay(), (int)(LocalTime.parse("12:22:21").toNanoOfDay() / 1000000L), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2020-03-19T12:22:14")), TimestampData.fromInstant((Instant)Instant.parse("2020-03-19T12:12:14Z")), false}));
    }

    @Test
    public void testDynamicIndexFromTimestamp() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{order_timestamp|yyyy_MM_dd_HH-ss}_index", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"2020_03_18_12-14_index", (Object)indexGenerator.generate(this.rows.get(0)));
        IndexGenerator indexGenerator1 = IndexGeneratorFactory.createIndexGenerator((String)"{order_timestamp|yyyy_MM_dd_HH_mm}_index", (TableSchema)this.schema);
        indexGenerator1.open();
        Assert.assertEquals((Object)"2020_03_19_12_22_index", (Object)indexGenerator1.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromDate() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_date|yyyy/MM/dd}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-2020/03/18", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-2020/03/19", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_time|HH-mm}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-12-12", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-12-22", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexDefaultFormat() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_time|}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-12_12_14", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-12_22_21", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexDefaultFormatTimestampWithLocalTimeZone() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_timestamp|}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-2020_03_18_12_12_14Z", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-2020_03_19_12_12_14Z", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testGeneralDynamicIndex() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"index_{item}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"index_apple", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"index_peanut", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testStaticIndex() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testUnknownField() {
        String expectedExceptionMsg = "Unknown field 'unknown_ts' in index pattern 'my-index-{unknown_ts|yyyy-MM-dd}', please check the field name.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{unknown_ts|yyyy-MM-dd}", (TableSchema)this.schema);
        }
        catch (TableException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)expectedExceptionMsg);
        }
    }

    @Test
    public void testUnsupportedTimeType() {
        String expectedExceptionMsg = "Unsupported type 'INT' found in Elasticsearch dynamic index field, time-related pattern only support types are: DATE,TIME,TIMESTAMP.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{id|yyyy-MM-dd}", (TableSchema)this.schema);
        }
        catch (TableException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedMultiParametersType() {
        String expectedExceptionMsg = "Chaining dynamic index pattern my-index-{local_date}-{local_time} is not supported, only support single dynamic index pattern.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date}-{local_time}", (TableSchema)this.schema);
        }
        catch (TableException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testDynamicIndexUnsupportedFormat() {
        String expectedExceptionMsg = "Unsupported field: HourOfDay";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_date|yyyy/MM/dd HH:mm}", (TableSchema)this.schema);
        }
        catch (UnsupportedTemporalTypeException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedIndexFieldType() {
        String expectedExceptionMsg = "Unsupported type BOOLEAN of index field, Supported types are: [DATE, TIME_WITHOUT_TIME_ZONE, TIMESTAMP_WITHOUT_TIME_ZONE, TIMESTAMP_WITH_TIME_ZONE, TIMESTAMP_WITH_LOCAL_TIME_ZONE, VARCHAR, CHAR, TINYINT, INTEGER, BIGINT]";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"index_{status}", (TableSchema)this.schema);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }
}

