/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.index;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.index.IndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.index.IndexGeneratorFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexGeneratorTest {
    private TableSchema schema;
    private List<Row> rows;

    @Before
    public void prepareData() {
        String[] fieldNames = new String[]{"id", "item", "log_ts", "log_date", "order_timestamp", "log_time", "local_datetime", "local_date", "local_time", "note", "status"};
        DataType[] dataTypes = new DataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.BIGINT(), (DataType)DataTypes.DATE().bridgedTo(Date.class), (DataType)DataTypes.TIMESTAMP().bridgedTo(Timestamp.class), (DataType)DataTypes.TIME().bridgedTo(Time.class), (DataType)DataTypes.TIMESTAMP().bridgedTo(LocalDateTime.class), (DataType)DataTypes.DATE().bridgedTo(LocalDate.class), (DataType)DataTypes.TIME().bridgedTo(LocalTime.class), DataTypes.STRING(), DataTypes.BOOLEAN()};
        this.schema = new TableSchema.Builder().fields(fieldNames, dataTypes).build();
        this.rows = new ArrayList<Row>();
        this.rows.add(Row.of((Object[])new Object[]{1, "apple", Timestamp.valueOf("2020-03-18 12:12:14").getTime(), Date.valueOf("2020-03-18"), Timestamp.valueOf("2020-03-18 12:12:14"), Time.valueOf("12:12:14"), LocalDateTime.of(2020, 3, 18, 12, 12, 14, 1000), LocalDate.of(2020, 3, 18), LocalTime.of(12, 13, 14, 2000), "test1", true}));
        this.rows.add(Row.of((Object[])new Object[]{2, "peanut", Timestamp.valueOf("2020-03-19 12:22:14").getTime(), Date.valueOf("2020-03-19"), Timestamp.valueOf("2020-03-19 12:22:21"), Time.valueOf("12:22:21"), LocalDateTime.of(2020, 3, 19, 12, 22, 14, 1000), LocalDate.of(2020, 3, 19), LocalTime.of(12, 13, 14, 2000), "test2", false}));
    }

    @Test
    public void testDynamicIndexFromTimestamp() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{order_timestamp|yyyy_MM_dd_HH-ss}_index", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"2020_03_18_12-14_index", (Object)indexGenerator.generate(this.rows.get(0)));
        IndexGenerator indexGenerator1 = IndexGeneratorFactory.createIndexGenerator((String)"{order_timestamp|yyyy_MM_dd_HH_mm}_index", (TableSchema)this.schema);
        indexGenerator1.open();
        Assert.assertEquals((Object)"2020_03_19_12_22_index", (Object)indexGenerator1.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromLocalDateTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{local_datetime|yyyy_MM_dd_HH-ss}_index", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"2020_03_18_12-14_index", (Object)indexGenerator.generate(this.rows.get(0)));
        IndexGenerator indexGenerator1 = IndexGeneratorFactory.createIndexGenerator((String)"{local_datetime|yyyy_MM_dd_HH_mm}_index", (TableSchema)this.schema);
        indexGenerator1.open();
        Assert.assertEquals((Object)"2020_03_19_12_22_index", (Object)indexGenerator1.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromDate() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_date|yyyy/MM/dd}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-2020/03/18", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-2020/03/19", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromLocalDate() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date|yyyy/MM/dd}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-2020/03/18", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-2020/03/19", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_time|HH-mm}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-12-12", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-12-22", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromLocalTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_time|HH-mm}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-12-13", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-12-13", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testDynamicIndexDefaultFormat() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_time|}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index-12_13_14", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index-12_13_14", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testGeneralDynamicIndex() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"index_{item}", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"index_apple", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"index_peanut", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testStaticIndex() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index", (TableSchema)this.schema);
        indexGenerator.open();
        Assert.assertEquals((Object)"my-index", (Object)indexGenerator.generate(this.rows.get(0)));
        Assert.assertEquals((Object)"my-index", (Object)indexGenerator.generate(this.rows.get(1)));
    }

    @Test
    public void testUnknownField() {
        String expectedExceptionMsg = "Unknown field 'unknown_ts' in index pattern 'my-index-{unknown_ts|yyyy-MM-dd}', please check the field name.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{unknown_ts|yyyy-MM-dd}", (TableSchema)this.schema);
        }
        catch (TableException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)expectedExceptionMsg);
        }
    }

    @Test
    public void testUnsupportedTimeType() {
        String expectedExceptionMsg = "Unsupported type 'INT' found in Elasticsearch dynamic index field, time-related pattern only support types are: DATE,TIME,TIMESTAMP.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{id|yyyy-MM-dd}", (TableSchema)this.schema);
        }
        catch (TableException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedMultiParametersType() {
        String expectedExceptionMsg = "Chaining dynamic index pattern my-index-{local_date}-{local_time} is not supported, only support single dynamic index pattern.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date}-{local_time}", (TableSchema)this.schema);
        }
        catch (TableException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testDynamicIndexUnsupportedFormat() {
        String expectedExceptionMsg = "Unsupported field: HourOfDay";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date|yyyy/MM/dd HH:mm}", (TableSchema)this.schema);
        }
        catch (UnsupportedTemporalTypeException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedIndexFieldType() {
        String expectedExceptionMsg = "Unsupported type Boolean of index field, Supported types are: [LocalDateTime, Timestamp, LocalDate, Date, LocalTime, Time, String, Short, Integer, Long]";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"index_{status}", (TableSchema)this.schema);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }
}

