/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.apache.flink.util.Preconditions;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;

class TestRequestIndexer
implements RequestIndexer {
    private final BulkProcessor bulkProcessor;
    private final boolean flushOnCheckpoint;
    private final AtomicLong numPendingRequestsRef;

    TestRequestIndexer(BulkProcessor bulkProcessor, boolean flushOnCheckpoint, AtomicLong numPendingRequestsRef) {
        this.bulkProcessor = (BulkProcessor)Preconditions.checkNotNull((Object)bulkProcessor);
        this.flushOnCheckpoint = flushOnCheckpoint;
        this.numPendingRequestsRef = (AtomicLong)Preconditions.checkNotNull((Object)numPendingRequestsRef);
    }

    public void add(DeleteRequest ... deleteRequests) {
        for (DeleteRequest deleteRequest : deleteRequests) {
            if (this.flushOnCheckpoint) {
                this.numPendingRequestsRef.getAndIncrement();
            }
            this.bulkProcessor.add(deleteRequest);
        }
    }

    public void add(IndexRequest ... indexRequests) {
        for (IndexRequest indexRequest : indexRequests) {
            if (this.flushOnCheckpoint) {
                this.numPendingRequestsRef.getAndIncrement();
            }
            this.bulkProcessor.add(indexRequest);
        }
    }

    public void add(UpdateRequest ... updateRequests) {
        for (UpdateRequest updateRequest : updateRequests) {
            if (this.flushOnCheckpoint) {
                this.numPendingRequestsRef.getAndIncrement();
            }
            this.bulkProcessor.add((DocWriteRequest)updateRequest);
        }
    }
}

