/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.connector.elasticsearch.table.KeyExtractor;
import org.apache.flink.connector.elasticsearch.table.LogicalTypeWithIndex;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.function.SerializableFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyExtractorTest {
    @Test
    public void testSimpleKey() {
        List logicalTypesWithIndex = Stream.of(new LogicalTypeWithIndex(0, ((DataType)DataTypes.BIGINT().notNull()).getLogicalType())).collect(Collectors.toList());
        SerializableFunction keyExtractor = KeyExtractor.createKeyExtractor(logicalTypesWithIndex, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{12L, StringData.fromString((String)"ABCD")}));
        Assertions.assertEquals((Object)key, (Object)"12");
    }

    @Test
    public void testNoPrimaryKey() {
        List logicalTypesWithIndex = Collections.emptyList();
        SerializableFunction keyExtractor = KeyExtractor.createKeyExtractor(logicalTypesWithIndex, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{12L, StringData.fromString((String)"ABCD")}));
        Assertions.assertEquals((Object)key, null);
    }

    @Test
    public void testTwoFieldsKey() {
        List logicalTypesWithIndex = Stream.of(new LogicalTypeWithIndex(0, ((DataType)DataTypes.BIGINT().notNull()).getLogicalType()), new LogicalTypeWithIndex(2, ((DataType)DataTypes.TIMESTAMP().notNull()).getLogicalType())).collect(Collectors.toList());
        SerializableFunction keyExtractor = KeyExtractor.createKeyExtractor(logicalTypesWithIndex, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{12L, StringData.fromString((String)"ABCD"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2012-12-12T12:12:12"))}));
        Assertions.assertEquals((Object)key, (Object)"12_2012-12-12T12:12:12");
    }

    @Test
    public void testAllTypesKey() {
        List logicalTypesWithIndex = Stream.of(new LogicalTypeWithIndex(0, ((DataType)DataTypes.TINYINT().notNull()).getLogicalType()), new LogicalTypeWithIndex(1, ((DataType)DataTypes.SMALLINT().notNull()).getLogicalType()), new LogicalTypeWithIndex(2, ((DataType)DataTypes.INT().notNull()).getLogicalType()), new LogicalTypeWithIndex(3, ((DataType)DataTypes.BIGINT().notNull()).getLogicalType()), new LogicalTypeWithIndex(4, ((DataType)DataTypes.BOOLEAN().notNull()).getLogicalType()), new LogicalTypeWithIndex(5, ((DataType)DataTypes.FLOAT().notNull()).getLogicalType()), new LogicalTypeWithIndex(6, ((DataType)DataTypes.DOUBLE().notNull()).getLogicalType()), new LogicalTypeWithIndex(7, ((DataType)DataTypes.STRING().notNull()).getLogicalType()), new LogicalTypeWithIndex(8, ((DataType)DataTypes.TIMESTAMP().notNull()).getLogicalType()), new LogicalTypeWithIndex(9, ((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull()).getLogicalType()), new LogicalTypeWithIndex(10, ((DataType)DataTypes.TIME().notNull()).getLogicalType()), new LogicalTypeWithIndex(11, ((DataType)DataTypes.DATE().notNull()).getLogicalType())).collect(Collectors.toList());
        SerializableFunction keyExtractor = KeyExtractor.createKeyExtractor(logicalTypesWithIndex, (String)"_");
        String key = (String)keyExtractor.apply(GenericRowData.of((Object[])new Object[]{(byte)1, (short)2, 3, 4L, true, Float.valueOf(1.0f), 2.0, StringData.fromString((String)"ABCD"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2012-12-12T12:12:12")), TimestampData.fromInstant((Instant)Instant.parse("2013-01-13T13:13:13Z")), (int)(LocalTime.parse("14:14:14").toNanoOfDay() / 1000000L), (int)LocalDate.parse("2015-05-15").toEpochDay()}));
        Assertions.assertEquals((Object)key, (Object)"1_2_3_4_true_1.0_2.0_ABCD_2012-12-12T12:12:12_2013-01-13T13:13:13_14:14:14_2015-05-15");
    }
}

