/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.connector.elasticsearch.table.IndexGenerator;
import org.apache.flink.connector.elasticsearch.table.IndexGeneratorFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class IndexGeneratorTest {
    private static final List<String> fieldNames = Arrays.asList("id", "item", "log_ts", "log_date", "order_timestamp", "log_time", "local_datetime", "local_date", "local_time", "local_timestamp", "note", "status");
    private static final List<DataType> dataTypes = Arrays.asList(DataTypes.INT(), DataTypes.STRING(), DataTypes.BIGINT(), (DataType)DataTypes.DATE().bridgedTo(Date.class), (DataType)DataTypes.TIMESTAMP().bridgedTo(Timestamp.class), (DataType)DataTypes.TIME().bridgedTo(Time.class), (DataType)DataTypes.TIMESTAMP().bridgedTo(LocalDateTime.class), (DataType)DataTypes.DATE().bridgedTo(LocalDate.class), (DataType)DataTypes.TIME().bridgedTo(LocalTime.class), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(), DataTypes.STRING(), DataTypes.BOOLEAN());
    private static final List<RowData> rows = Arrays.asList(GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"apple"), Timestamp.valueOf("2020-03-18 12:12:14").getTime(), (int)Date.valueOf("2020-03-18").toLocalDate().toEpochDay(), TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("2020-03-18 12:12:14")), (int)(Time.valueOf("12:12:14").toLocalTime().toNanoOfDay() / 1000000L), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2020, 3, 18, 12, 12, 14, 1000)), (int)LocalDate.of(2020, 3, 18).toEpochDay(), (int)(LocalTime.of(12, 13, 14, 2000).toNanoOfDay() / 1000000L), TimestampData.fromInstant((Instant)LocalDateTime.of(2020, 3, 18, 3, 12, 14, 1000).atZone(ZoneId.of("Asia/Shanghai")).toInstant()), "test1", true}), GenericRowData.of((Object[])new Object[]{2, StringData.fromString((String)"peanut"), Timestamp.valueOf("2020-03-19 12:22:14").getTime(), (int)Date.valueOf("2020-03-19").toLocalDate().toEpochDay(), TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("2020-03-19 12:22:21")), (int)(Time.valueOf("12:22:21").toLocalTime().toNanoOfDay() / 1000000L), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2020, 3, 19, 12, 22, 14, 1000)), (int)LocalDate.of(2020, 3, 19).toEpochDay(), (int)(LocalTime.of(12, 13, 14, 2000).toNanoOfDay() / 1000000L), TimestampData.fromInstant((Instant)LocalDateTime.of(2020, 3, 19, 20, 22, 14, 1000).atZone(ZoneId.of("America/Los_Angeles")).toInstant()), "test2", false}));

    @Test
    public void testDynamicIndexFromTimestampTzUTC() {
        Assumptions.assumingThat((boolean)ZoneId.systemDefault().equals(ZoneId.of("UTC")), () -> {
            IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{local_timestamp|yyyy_MM_dd_HH-ss}_index", fieldNames, dataTypes);
            indexGenerator.open();
            Assertions.assertEquals((Object)"2020_03_17_19-14_index", (Object)indexGenerator.generate(rows.get(0)));
            Assertions.assertEquals((Object)"2020_03_20_03-14_index", (Object)indexGenerator.generate(rows.get(1)));
        });
    }

    @Test
    public void testDynamicIndexFromTimestampTzWithSpecificTimezone() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{local_timestamp|yyyy_MM_dd_HH-ss}_index", fieldNames, dataTypes, (ZoneId)ZoneId.of("Europe/Berlin"));
        indexGenerator.open();
        Assertions.assertEquals((Object)"2020_03_17_20-14_index", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"2020_03_20_04-14_index", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromTimestamp() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{order_timestamp|yyyy_MM_dd_HH-ss}_index", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"2020_03_18_12-14_index", (Object)indexGenerator.generate(rows.get(0)));
        IndexGenerator indexGenerator1 = IndexGeneratorFactory.createIndexGenerator((String)"{order_timestamp|yyyy_MM_dd_HH_mm}_index", fieldNames, dataTypes);
        indexGenerator1.open();
        Assertions.assertEquals((Object)"2020_03_19_12_22_index", (Object)indexGenerator1.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromLocalDateTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"{local_datetime|yyyy_MM_dd_HH-ss}_index", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"2020_03_18_12-14_index", (Object)indexGenerator.generate(rows.get(0)));
        IndexGenerator indexGenerator1 = IndexGeneratorFactory.createIndexGenerator((String)"{local_datetime|yyyy_MM_dd_HH_mm}_index", fieldNames, dataTypes);
        indexGenerator1.open();
        Assertions.assertEquals((Object)"2020_03_19_12_22_index", (Object)indexGenerator1.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromDate() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_date|yyyy/MM/dd}", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"my-index-2020/03/18", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"my-index-2020/03/19", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromLocalDate() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date|yyyy/MM/dd}", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"my-index-2020/03/18", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"my-index-2020/03/19", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{log_time|HH-mm}", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"my-index-12-12", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"my-index-12-22", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromLocalTime() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_time|HH-mm}", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"my-index-12-13", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"my-index-12-13", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexDefaultFormat() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_time|}", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"my-index-12_13_14", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"my-index-12_13_14", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testDynamicIndexFromSystemTime() {
        List<String> supportedUseCases = Arrays.asList("now()", "NOW()", "now( )", "NOW(\t)", "\t NOW( ) \t", "current_timestamp", "CURRENT_TIMESTAMP", "\tcurrent_timestamp\t", " current_timestamp ");
        supportedUseCases.stream().forEach(f -> {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy_MM_dd");
            IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)String.format("my-index-{%s|yyyy_MM_dd}", f), fieldNames, dataTypes);
            indexGenerator.open();
            String expectedIndex1 = "my-index-" + LocalDateTime.now().format(dateTimeFormatter);
            String actualIndex = indexGenerator.generate(rows.get(1));
            String expectedIndex2 = "my-index-" + LocalDateTime.now().format(dateTimeFormatter);
            Assertions.assertTrue((actualIndex.equals(expectedIndex1) || actualIndex.equals(expectedIndex2) ? 1 : 0) != 0);
        });
        List<String> invalidUseCases = Arrays.asList("now", "now(", "NOW", "NOW)", "current_timestamp()", "CURRENT_TIMESTAMP()", "CURRENT_timestamp");
        invalidUseCases.stream().forEach(f -> {
            String expectedExceptionMsg = String.format("Unknown field '%s' in index pattern 'my-index-{%s|yyyy_MM_dd}', please check the field name.", f, f);
            try {
                IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)String.format("my-index-{%s|yyyy_MM_dd}", f), fieldNames, dataTypes);
                indexGenerator.open();
            }
            catch (TableException e) {
                Assertions.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
            }
        });
    }

    @Test
    public void testGeneralDynamicIndex() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"index_{item}", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"index_apple", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"index_peanut", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testStaticIndex() {
        IndexGenerator indexGenerator = IndexGeneratorFactory.createIndexGenerator((String)"my-index", fieldNames, dataTypes);
        indexGenerator.open();
        Assertions.assertEquals((Object)"my-index", (Object)indexGenerator.generate(rows.get(0)));
        Assertions.assertEquals((Object)"my-index", (Object)indexGenerator.generate(rows.get(1)));
    }

    @Test
    public void testUnknownField() {
        String expectedExceptionMsg = "Unknown field 'unknown_ts' in index pattern 'my-index-{unknown_ts|yyyy-MM-dd}', please check the field name.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{unknown_ts|yyyy-MM-dd}", fieldNames, dataTypes);
        }
        catch (TableException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)expectedExceptionMsg);
        }
    }

    @Test
    public void testUnsupportedTimeType() {
        String expectedExceptionMsg = "Unsupported type 'INT' found in Elasticsearch dynamic index field, time-related pattern only support types are: DATE,TIME,TIMESTAMP.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{id|yyyy-MM-dd}", fieldNames, dataTypes);
        }
        catch (TableException e) {
            Assertions.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedMultiParametersType() {
        String expectedExceptionMsg = "Chaining dynamic index pattern my-index-{local_date}-{local_time} is not supported, only support single dynamic index pattern.";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date}-{local_time}", fieldNames, dataTypes);
        }
        catch (TableException e) {
            Assertions.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testDynamicIndexUnsupportedFormat() {
        String expectedExceptionMsg = "Unsupported field: HourOfDay";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"my-index-{local_date|yyyy/MM/dd HH:mm}", fieldNames, dataTypes);
        }
        catch (UnsupportedTemporalTypeException e) {
            Assertions.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedIndexFieldType() {
        String expectedExceptionMsg = "Unsupported type BOOLEAN of index field, Supported types are: [DATE, TIME_WITHOUT_TIME_ZONE, TIMESTAMP_WITHOUT_TIME_ZONE, TIMESTAMP_WITH_TIME_ZONE, TIMESTAMP_WITH_LOCAL_TIME_ZONE, VARCHAR, CHAR, TINYINT, INTEGER, BIGINT]";
        try {
            IndexGeneratorFactory.createIndexGenerator((String)"index_{status}", fieldNames, dataTypes);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)expectedExceptionMsg, (Object)e.getMessage());
        }
    }
}

