/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.connector.elasticsearch.ElasticsearchUtil;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchDynamicSink;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchDynamicSinkFactoryBase;
import org.apache.flink.connector.elasticsearch.table.TestContext;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;

@ExtendWith(value={TestLoggerExtension.class})
abstract class ElasticsearchDynamicSinkFactoryBaseTest {
    ElasticsearchDynamicSinkFactoryBaseTest() {
    }

    abstract ElasticsearchDynamicSinkFactoryBase createSinkFactory();

    abstract TestContext createPrefilledTestContext();

    void assertValidationException(String expectedMessage, Executable executable) {
        ValidationException thrown = (ValidationException)org.junit.jupiter.api.Assertions.assertThrows(ValidationException.class, (Executable)executable);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedMessage, (Object)thrown.getMessage());
    }

    @Test
    public void validateWrongIndex() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("'index' must not be empty", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.INDEX_OPTION.key(), "").build()));
    }

    @Test
    public void validateWrongHosts() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("Could not parse host 'wrong-host' in option 'hosts'. It should follow the format 'http://host_name:port'.", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.HOSTS_OPTION.key(), "wrong-host").build()));
    }

    @Test
    public void validateWrongFlushSize() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("'sink.bulk-flush.max-size' must be in MB granularity. Got: 1024 bytes", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.BULK_FLUSH_MAX_SIZE_OPTION.key(), "1kb").build()));
    }

    @Test
    public void validateWrongRetries() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("'sink.bulk-flush.backoff.max-retries' must be at least 1. Got: 0", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION.key(), "0").build()));
    }

    @Test
    public void validateWrongMaxActions() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("'sink.bulk-flush.max-actions' must be at least 1. Got: -2", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION.key(), "-2").build()));
    }

    @Test
    public void validateWrongBackoffDelay() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("Invalid value for option 'sink.bulk-flush.backoff.delay'.", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION.key(), "-1s").build()));
    }

    @Test
    public void validatePrimaryKeyOnIllegalColumn() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("The table has a primary key on columns of illegal types: [ARRAY, MAP, MULTISET, ROW, RAW, VARBINARY].", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withSchema(new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"b", (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())).notNull())), Column.physical((String)"c", (DataType)((DataType)DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.STRING()).notNull())), Column.physical((String)"d", (DataType)((DataType)DataTypes.MULTISET((DataType)((DataType)DataTypes.BIGINT().notNull())).notNull())), Column.physical((String)"e", (DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BIGINT())}).notNull())), Column.physical((String)"f", (DataType)((DataType)DataTypes.RAW(Void.class, (TypeSerializer)VoidSerializer.INSTANCE).notNull())), Column.physical((String)"g", (DataType)((DataType)DataTypes.BYTES().notNull()))), Collections.emptyList(), UniqueConstraint.primaryKey((String)"name", Arrays.asList("a", "b", "c", "d", "e", "f", "g")))).build()));
    }

    @Test
    public void validateWrongCredential() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        this.assertValidationException("'username' and 'password' must be set at the same time. Got: username 'username' and password ''", () -> sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.USERNAME_OPTION.key(), "username").withOption(ElasticsearchConnectorOptions.PASSWORD_OPTION.key(), "").build()));
    }

    @Test
    public void validateDynamicIndexOnChangelogStream() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        DynamicTableSink sink = sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(ElasticsearchConnectorOptions.INDEX_OPTION.key(), "dynamic-index-{now()|yyyy-MM-dd}_index").build());
        ChangelogMode changelogMode = ChangelogMode.newBuilder().addContainedKind(RowKind.DELETE).addContainedKind(RowKind.INSERT).build();
        this.assertValidationException("Dynamic indexing based on system time only works on append only stream.", () -> sink.getChangelogMode(changelogMode));
    }

    @Test
    public void testSinkParallelism() {
        ElasticsearchDynamicSinkFactoryBase sinkFactory = this.createSinkFactory();
        DynamicTableSink sink = sinkFactory.createDynamicTableSink(this.createPrefilledTestContext().withOption(FactoryUtil.SINK_PARALLELISM.key(), "2").build());
        Assertions.assertThat((Object)sink).isInstanceOf(ElasticsearchDynamicSink.class);
        ElasticsearchDynamicSink esSink = (ElasticsearchDynamicSink)sink;
        SinkV2Provider provider = (SinkV2Provider)esSink.getSinkRuntimeProvider((DynamicTableSink.Context)new ElasticsearchUtil.MockContext());
        Assertions.assertThat((int)2).isEqualTo(provider.getParallelism().get());
    }
}

