/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.RequestIndexer;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

class TestEmitter
implements ElasticsearchEmitter<Tuple2<Integer, String>> {
    private final String index;
    private final XContentBuilderProvider xContentBuilderProvider;
    private final String dataFieldName;

    public static TestEmitter jsonEmitter(String index, String dataFieldName) {
        return new TestEmitter(index, dataFieldName, XContentFactory::jsonBuilder);
    }

    public static TestEmitter smileEmitter(String index, String dataFieldName) {
        return new TestEmitter(index, dataFieldName, XContentFactory::smileBuilder);
    }

    private TestEmitter(String index, String dataFieldName, XContentBuilderProvider xContentBuilderProvider) {
        this.dataFieldName = dataFieldName;
        this.index = index;
        this.xContentBuilderProvider = xContentBuilderProvider;
    }

    public void emit(Tuple2<Integer, String> element, SinkWriter.Context context, RequestIndexer indexer) {
        indexer.add(new IndexRequest[]{this.createIndexRequest(element)});
    }

    private IndexRequest createIndexRequest(Tuple2<Integer, String> element) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        document.put(this.dataFieldName, element.f1);
        try {
            return new IndexRequest(this.index).id(((Integer)element.f0).toString()).type("test-document-type").source(this.xContentBuilderProvider.getBuilder().map(document));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    private static interface XContentBuilderProvider
    extends Serializable {
        public XContentBuilder getBuilder() throws IOException;
    }
}

