/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.io.IOException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.junit.jupiter.api.Assertions;

abstract class TestClientBase {
    static final String DOCUMENT_TYPE = "test-document-type";
    private static final String DATA_FIELD_NAME = "data";
    final RestHighLevelClient client;

    TestClientBase(RestHighLevelClient client) {
        this.client = client;
    }

    abstract GetResponse getResponse(String var1, int var2) throws IOException;

    void assertThatIdsAreNotWritten(String index, int ... ids) throws IOException {
        for (int id : ids) {
            try {
                GetResponse response = this.getResponse(index, id);
                Assertions.assertFalse((boolean)response.isExists(), (String)String.format("Id %s is unexpectedly present.", id));
            }
            catch (ElasticsearchStatusException e) {
                Assertions.assertEquals((int)404, (int)e.status().getStatus());
            }
        }
    }

    void assertThatIdsAreWritten(String index, int ... ids) throws IOException, InterruptedException {
        for (int id : ids) {
            GetResponse response;
            do {
                response = this.getResponse(index, id);
                Thread.sleep(10L);
            } while (response.isSourceEmpty());
            Assertions.assertEquals((Object)TestClientBase.buildMessage(id), response.getSource().get(DATA_FIELD_NAME));
        }
    }

    String getDataFieldName() {
        return DATA_FIELD_NAME;
    }

    static String buildMessage(int id) {
        return "test-" + id;
    }
}

