/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.io.Serializable;
import java.util.stream.Stream;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchSink;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchSinkBuilderBase;
import org.apache.flink.connector.elasticsearch.sink.FlushBackoffType;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.http.HttpHost;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
abstract class ElasticsearchSinkBuilderBaseTest<B extends ElasticsearchSinkBuilderBase<Object, B>> {
    ElasticsearchSinkBuilderBaseTest() {
    }

    @TestFactory
    Stream<DynamicTest> testValidBuilders() {
        Stream<ElasticsearchSinkBuilderBase> validBuilders = Stream.of(this.createMinimalBuilder(), this.createMinimalBuilder().setDeliveryGuarantee(DeliveryGuarantee.AT_LEAST_ONCE), this.createMinimalBuilder().setBulkFlushBackoffStrategy(FlushBackoffType.CONSTANT, 1, 1L), this.createMinimalBuilder().setConnectionUsername("username").setConnectionPassword("password"));
        return DynamicTest.stream(validBuilders, ElasticsearchSinkBuilderBase::toString, builder -> {
            ElasticsearchSink cfr_ignored_0 = (ElasticsearchSink)org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((ElasticsearchSinkBuilderBase)builder).build());
        });
    }

    @Test
    void testDefaultDeliveryGuarantee() {
        Assertions.assertThat((Comparable)this.createMinimalBuilder().build().getDeliveryGuarantee()).isEqualTo((Object)DeliveryGuarantee.AT_LEAST_ONCE);
    }

    @Test
    void testThrowIfExactlyOnceConfigured() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.createMinimalBuilder().setDeliveryGuarantee(DeliveryGuarantee.EXACTLY_ONCE));
    }

    @Test
    void testThrowIfHostsNotSet() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.createEmptyBuilder().setEmitter((ElasticsearchEmitter & Serializable)(element, indexer, context) -> {}).build());
    }

    @Test
    void testThrowIfEmitterNotSet() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.createEmptyBuilder().setHosts(new HttpHost[]{new HttpHost("localhost:3000")}).build());
    }

    @Test
    void testThrowIfSetInvalidTimeouts() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.createEmptyBuilder().setConnectionRequestTimeout(-1).build());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.createEmptyBuilder().setConnectionTimeout(-1).build());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.createEmptyBuilder().setSocketTimeout(-1).build());
    }

    abstract B createEmptyBuilder();

    abstract B createMinimalBuilder();
}

