/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch;

import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.slf4j.Logger;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

@Internal
public class ElasticsearchUtil {
    private ElasticsearchUtil() {
    }

    public static ElasticsearchContainer createElasticsearchContainer(String dockerImageVersion, Logger log) {
        String logLevel = log.isTraceEnabled() ? "TRACE" : (log.isDebugEnabled() ? "DEBUG" : (log.isInfoEnabled() ? "INFO" : (log.isWarnEnabled() ? "WARN" : (log.isErrorEnabled() ? "ERROR" : "OFF"))));
        return (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(DockerImageName.parse((String)dockerImageVersion)).withEnv("ES_JAVA_OPTS", "-Xms2g -Xmx2g")).withEnv("logger.org.elasticsearch", logLevel)).withLogConsumer((Consumer)new Slf4jLogConsumer(log));
    }

    public static class MockContext
    implements DynamicTableSink.Context {
        public boolean isBounded() {
            return false;
        }

        public TypeInformation<?> createTypeInformation(DataType consumedDataType) {
            return null;
        }

        public TypeInformation<?> createTypeInformation(LogicalType consumedLogicalType) {
            return null;
        }

        public DynamicTableSink.DataStructureConverter createDataStructureConverter(DataType consumedDataType) {
            return null;
        }
    }
}

