/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.table.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.aws.table.util.AsyncClientOptionsUtils;
import org.apache.flink.connector.base.table.AsyncSinkConnectorOptions;
import org.apache.flink.connector.base.table.sink.options.AsyncSinkConfigurationValidator;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.connector.kinesis.table.KinesisConnectorOptions;
import org.apache.flink.connector.kinesis.table.KinesisPartitionKeyGeneratorFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KinesisStreamsConnectorOptionsUtils {
    public static final String KINESIS_CLIENT_PROPERTIES_KEY = "sink.client.properties";
    private final AsyncClientOptionsUtils asyncClientOptionsUtils;
    private final AsyncSinkConfigurationValidator asyncSinkconfigurationValidator;
    private final Map<String, String> resolvedOptions;
    private final ReadableConfig tableOptions;
    private final PartitionKeyGenerator<RowData> partitioner;
    private static final String[] NON_VALIDATED_PREFIXES = new String[]{"aws.", "sink.http-client.", "sink.producer."};

    public KinesisStreamsConnectorOptionsUtils(Map<String, String> options, ReadableConfig tableOptions, RowType physicalType, List<String> partitionKeys, ClassLoader classLoader) {
        KinesisProducerOptionsMapper optionsMapper = new KinesisProducerOptionsMapper(tableOptions, options);
        this.resolvedOptions = optionsMapper.mapDeprecatedClientOptions();
        this.tableOptions = optionsMapper.mapDeprecatedTableOptions();
        this.asyncSinkconfigurationValidator = new AsyncSinkConfigurationValidator(this.tableOptions);
        this.asyncClientOptionsUtils = new AsyncClientOptionsUtils(this.resolvedOptions);
        this.partitioner = KinesisPartitionKeyGeneratorFactory.getKinesisPartitioner(tableOptions, physicalType, partitionKeys, classLoader);
    }

    public Properties getValidatedSinkConfigurations() {
        Properties properties = this.asyncSinkconfigurationValidator.getValidatedConfigurations();
        properties.put(KinesisConnectorOptions.STREAM.key(), this.tableOptions.get(KinesisConnectorOptions.STREAM));
        Properties kinesisClientProps = this.asyncClientOptionsUtils.getValidatedConfigurations();
        properties.put(KINESIS_CLIENT_PROPERTIES_KEY, kinesisClientProps);
        properties.put(KinesisConnectorOptions.SINK_PARTITIONER.key(), this.partitioner);
        if (this.tableOptions.getOptional(KinesisConnectorOptions.SINK_FAIL_ON_ERROR).isPresent()) {
            properties.put(KinesisConnectorOptions.SINK_FAIL_ON_ERROR.key(), this.tableOptions.getOptional(KinesisConnectorOptions.SINK_FAIL_ON_ERROR).get());
        }
        return properties;
    }

    public List<String> getNonValidatedPrefixes() {
        return Arrays.asList(NON_VALIDATED_PREFIXES);
    }

    @Internal
    public static class KinesisProducerOptionsMapper {
        private static final Logger LOG = LoggerFactory.getLogger(KinesisProducerOptionsMapper.class);
        public static final String KINESIS_PRODUCER_PREFIX = "sink.producer.";
        private static final String KINESIS_PRODUCER_ENDPOINT = "sink.producer.kinesis-endpoint";
        private static final String KINESIS_PRODUCER_PORT = "sink.producer.kinesis-port";
        private static final String KINESIS_PRODUCER_VERIFY_CERTIFICATE = "sink.producer.verify-certificate";
        private static final String DEPRECATED_FLUSH_BUFFER_TIMEOUT_KEY = "sink.producer.record-max-buffered-time";
        private static final String DEPRECATED_MAX_BATCH_SIZE_KEY = "sink.producer.collection-max-size";
        private static final String DEPRECATED_MAX_INFLIGHT_REQUESTS_KEY = "sink.producer.collection-max-count";
        private static final String DEPRECATED_SINK_FAIL_ON_ERROR_KEY = "sink.producer.fail-on-error";
        private final ReadableConfig tableOptions;
        private final Map<String, String> resolvedOptions;

        public KinesisProducerOptionsMapper(ReadableConfig tableOptions, Map<String, String> resolvedOptions) {
            this.tableOptions = tableOptions;
            this.resolvedOptions = resolvedOptions;
        }

        @VisibleForTesting
        public KinesisProducerOptionsMapper(Map<String, String> allOptions) {
            this.tableOptions = Configuration.fromMap(allOptions);
            this.resolvedOptions = allOptions;
        }

        public Map<String, String> mapDeprecatedClientOptions() {
            this.mapDeprecatedEndpoint();
            this.mapDeprecatedVerifyCertificate();
            this.removeMappedOptions();
            this.resolvedOptions.keySet().forEach(this::warnForDeprecatedOption);
            return this.resolvedOptions;
        }

        public ReadableConfig mapDeprecatedTableOptions() {
            Configuration mappedConfig = new Configuration();
            mappedConfig.set(KinesisConnectorOptions.STREAM, this.tableOptions.get(KinesisConnectorOptions.STREAM));
            this.tableOptions.getOptional(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE).ifPresent(val -> mappedConfig.set(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE, val));
            this.tableOptions.getOptional(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS).ifPresent(val -> mappedConfig.set(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS, val));
            this.tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER).ifPresent(val -> mappedConfig.set(KinesisConnectorOptions.SINK_PARTITIONER, val));
            this.tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER).ifPresent(val -> mappedConfig.set(KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER, val));
            this.replaceDeprecatedOptionInConfig(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT, DEPRECATED_FLUSH_BUFFER_TIMEOUT_KEY, mappedConfig);
            this.replaceDeprecatedOptionInConfig(AsyncSinkConnectorOptions.MAX_BATCH_SIZE, DEPRECATED_MAX_BATCH_SIZE_KEY, mappedConfig);
            this.replaceDeprecatedOptionInConfig(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS, DEPRECATED_MAX_INFLIGHT_REQUESTS_KEY, mappedConfig);
            this.replaceDeprecatedOptionInConfig(KinesisConnectorOptions.SINK_FAIL_ON_ERROR, DEPRECATED_SINK_FAIL_ON_ERROR_KEY, mappedConfig);
            return mappedConfig;
        }

        public static Set<ConfigOption<?>> addDeprecatedKeys(Set<ConfigOption<?>> tableOptions) {
            HashSet tableOptionsWithDeprecatedKeys = new HashSet(tableOptions);
            tableOptionsWithDeprecatedKeys.remove(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT);
            tableOptionsWithDeprecatedKeys.add(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT.withDeprecatedKeys(new String[]{DEPRECATED_FLUSH_BUFFER_TIMEOUT_KEY}));
            tableOptionsWithDeprecatedKeys.remove(AsyncSinkConnectorOptions.MAX_BATCH_SIZE);
            tableOptionsWithDeprecatedKeys.add(AsyncSinkConnectorOptions.MAX_BATCH_SIZE.withDeprecatedKeys(new String[]{DEPRECATED_MAX_BATCH_SIZE_KEY}));
            tableOptionsWithDeprecatedKeys.remove(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS);
            tableOptionsWithDeprecatedKeys.add(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS.withDeprecatedKeys(new String[]{DEPRECATED_MAX_INFLIGHT_REQUESTS_KEY}));
            tableOptionsWithDeprecatedKeys.remove(KinesisConnectorOptions.SINK_FAIL_ON_ERROR);
            tableOptionsWithDeprecatedKeys.add(KinesisConnectorOptions.SINK_FAIL_ON_ERROR.withDeprecatedKeys(new String[]{DEPRECATED_SINK_FAIL_ON_ERROR_KEY}));
            return tableOptionsWithDeprecatedKeys;
        }

        private void mapDeprecatedEndpoint() {
            if (this.resolvedOptions.containsKey(KINESIS_PRODUCER_ENDPOINT)) {
                if (this.resolvedOptions.containsKey(KINESIS_PRODUCER_PORT)) {
                    this.resolvedOptions.putIfAbsent("aws.endpoint", String.format("https://%s:%s", this.resolvedOptions.get(KINESIS_PRODUCER_ENDPOINT), this.resolvedOptions.get(KINESIS_PRODUCER_PORT)));
                } else {
                    this.resolvedOptions.putIfAbsent("aws.endpoint", String.format("https://%s", this.resolvedOptions.get(KINESIS_PRODUCER_ENDPOINT)));
                }
            }
        }

        private void mapDeprecatedVerifyCertificate() {
            if (this.resolvedOptions.containsKey(KINESIS_PRODUCER_VERIFY_CERTIFICATE)) {
                String value = this.resolvedOptions.get(KINESIS_PRODUCER_VERIFY_CERTIFICATE);
                if (value.equalsIgnoreCase("true")) {
                    this.resolvedOptions.putIfAbsent("aws.trust.all.certificates", "false");
                } else if (value.equalsIgnoreCase("false")) {
                    this.resolvedOptions.putIfAbsent("aws.trust.all.certificates", "true");
                } else {
                    LOG.warn(String.format("Option %s is ignored due to invalid value", KINESIS_PRODUCER_VERIFY_CERTIFICATE));
                }
            }
        }

        private void removeMappedOptions() {
            this.resolvedOptions.remove(KINESIS_PRODUCER_VERIFY_CERTIFICATE);
            this.resolvedOptions.remove(KINESIS_PRODUCER_ENDPOINT);
            this.resolvedOptions.remove(KINESIS_PRODUCER_PORT);
            this.resolvedOptions.remove(DEPRECATED_FLUSH_BUFFER_TIMEOUT_KEY);
            this.resolvedOptions.remove(DEPRECATED_MAX_BATCH_SIZE_KEY);
            this.resolvedOptions.remove(DEPRECATED_MAX_INFLIGHT_REQUESTS_KEY);
            this.resolvedOptions.remove(DEPRECATED_SINK_FAIL_ON_ERROR_KEY);
        }

        private void warnForDeprecatedOption(String key) {
            if (key.startsWith(KINESIS_PRODUCER_PREFIX)) {
                LOG.warn(String.format("Key %s is unsupported by Kinesis Datastream Sink", key));
            }
        }

        private <T> void replaceDeprecatedOptionInConfig(ConfigOption<T> option, String deprecatedKey, Configuration config) {
            this.tableOptions.getOptional(option.withDeprecatedKeys(new String[]{deprecatedKey})).ifPresent(v -> config.set(option, v));
            this.tableOptions.getOptional(option).ifPresent(v -> config.set(option, v));
        }
    }
}

