/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;

@Internal
public class KinesisStreamsSinkElementConverter<InputT>
implements ElementConverter<InputT, PutRecordsRequestEntry> {
    private final SerializationSchema<InputT> serializationSchema;
    private final PartitionKeyGenerator<InputT> partitionKeyGenerator;
    private boolean schemaOpened = false;

    private KinesisStreamsSinkElementConverter(SerializationSchema<InputT> serializationSchema, PartitionKeyGenerator<InputT> partitionKeyGenerator) {
        this.serializationSchema = serializationSchema;
        this.partitionKeyGenerator = partitionKeyGenerator;
    }

    public PutRecordsRequestEntry apply(InputT element, SinkWriter.Context context) {
        this.checkOpened();
        return (PutRecordsRequestEntry)PutRecordsRequestEntry.builder().data(SdkBytes.fromByteArray((byte[])this.serializationSchema.serialize(element))).partitionKey((String)this.partitionKeyGenerator.apply(element)).build();
    }

    private void checkOpened() {
        if (!this.schemaOpened) {
            try {
                this.serializationSchema.open(new SerializationSchema.InitializationContext(){

                    public MetricGroup getMetricGroup() {
                        return new UnregisteredMetricsGroup();
                    }

                    public UserCodeClassLoader getUserCodeClassLoader() {
                        return SimpleUserCodeClassLoader.create((ClassLoader)KinesisStreamsSinkElementConverter.class.getClassLoader());
                    }
                });
                this.schemaOpened = true;
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to initialize serialization schema.", (Throwable)e);
            }
        }
    }

    public static <InputT> Builder<InputT> builder() {
        return new Builder();
    }

    public static class Builder<InputT> {
        private SerializationSchema<InputT> serializationSchema;
        private PartitionKeyGenerator<InputT> partitionKeyGenerator;

        public Builder<InputT> setSerializationSchema(SerializationSchema<InputT> serializationSchema) {
            this.serializationSchema = serializationSchema;
            return this;
        }

        public Builder<InputT> setPartitionKeyGenerator(PartitionKeyGenerator<InputT> partitionKeyGenerator) {
            this.partitionKeyGenerator = partitionKeyGenerator;
            return this;
        }

        public KinesisStreamsSinkElementConverter<InputT> build() {
            Preconditions.checkNotNull(this.serializationSchema, (String)"No SerializationSchema was supplied to the KinesisStreamsSinkElementConverter builder.");
            Preconditions.checkNotNull(this.partitionKeyGenerator, (String)"No PartitionKeyGenerator lambda was supplied to the KinesisStreamsSinkElementConverter builder.");
            return new KinesisStreamsSinkElementConverter(this.serializationSchema, this.partitionKeyGenerator);
        }
    }
}

