/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.sink;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriterStateSerializer;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;

@Internal
public class KinesisStreamsStateSerializer
extends AsyncSinkWriterStateSerializer<PutRecordsRequestEntry> {
    protected void serializeRequestToStream(PutRecordsRequestEntry request, DataOutputStream out) throws IOException {
        out.write(request.data().asByteArrayUnsafe());
        this.serializePartitionKeyToStream(request.partitionKey(), out);
        this.validateExplicitHashKey(request);
    }

    protected void serializePartitionKeyToStream(String partitionKey, DataOutputStream out) throws IOException {
        out.writeInt(partitionKey.length());
        out.write(partitionKey.getBytes(StandardCharsets.UTF_8));
    }

    protected void validateExplicitHashKey(PutRecordsRequestEntry request) {
        if (request.explicitHashKey() != null) {
            throw new IllegalStateException(String.format("KinesisStreamsStateSerializer is incompatible with ElementConverter.Serializer version %d  does not support explicit hash key.", this.getVersion()));
        }
    }

    protected PutRecordsRequestEntry deserializeRequestFromStream(long requestSize, DataInputStream in) throws IOException {
        byte[] requestData = new byte[(int)requestSize];
        in.read(requestData);
        return (PutRecordsRequestEntry)PutRecordsRequestEntry.builder().data(SdkBytes.fromByteArray((byte[])requestData)).partitionKey(this.deserializePartitionKeyFromStream(in)).build();
    }

    protected String deserializePartitionKeyFromStream(DataInputStream in) throws IOException {
        int partitionKeyLength = in.readInt();
        byte[] requestPartitionKeyData = new byte[partitionKeyLength];
        in.read(requestPartitionKeyData);
        return new String(requestPartitionKeyData, StandardCharsets.UTF_8);
    }

    public int getVersion() {
        return 1;
    }
}

