/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.util.Preconditions;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;

@Internal
public class KinesisStreamsSinkElementConverter<InputT>
implements ElementConverter<InputT, PutRecordsRequestEntry> {
    private final SerializationSchema<InputT> serializationSchema;
    private final PartitionKeyGenerator<InputT> partitionKeyGenerator;

    private KinesisStreamsSinkElementConverter(SerializationSchema<InputT> serializationSchema, PartitionKeyGenerator<InputT> partitionKeyGenerator) {
        this.serializationSchema = serializationSchema;
        this.partitionKeyGenerator = partitionKeyGenerator;
    }

    public PutRecordsRequestEntry apply(InputT element, SinkWriter.Context context) {
        return (PutRecordsRequestEntry)PutRecordsRequestEntry.builder().data(SdkBytes.fromByteArray((byte[])this.serializationSchema.serialize(element))).partitionKey((String)this.partitionKeyGenerator.apply(element)).build();
    }

    public static <InputT> Builder<InputT> builder() {
        return new Builder();
    }

    public static class Builder<InputT> {
        private SerializationSchema<InputT> serializationSchema;
        private PartitionKeyGenerator<InputT> partitionKeyGenerator;

        public Builder<InputT> setSerializationSchema(SerializationSchema<InputT> serializationSchema) {
            this.serializationSchema = serializationSchema;
            return this;
        }

        public Builder<InputT> setPartitionKeyGenerator(PartitionKeyGenerator<InputT> partitionKeyGenerator) {
            this.partitionKeyGenerator = partitionKeyGenerator;
            return this;
        }

        public KinesisStreamsSinkElementConverter<InputT> build() {
            Preconditions.checkNotNull(this.serializationSchema, (String)"No SerializationSchema was supplied to the KinesisStreamsSinkElementConverter builder.");
            Preconditions.checkNotNull(this.partitionKeyGenerator, (String)"No PartitionKeyGenerator lambda was supplied to the KinesisStreamsSinkElementConverter builder.");
            return new KinesisStreamsSinkElementConverter(this.serializationSchema, this.partitionKeyGenerator);
        }
    }
}

