/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.sink;

import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.base.sink.AsyncSinkBaseBuilder;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsSink;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsSinkElementConverter;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;

@PublicEvolving
public class KinesisStreamsSinkBuilder<InputT>
extends AsyncSinkBaseBuilder<InputT, PutRecordsRequestEntry, KinesisStreamsSinkBuilder<InputT>> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 500;
    private static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS = 50;
    private static final int DEFAULT_MAX_BUFFERED_REQUESTS = 10000;
    private static final long DEFAULT_MAX_BATCH_SIZE_IN_B = 0x500000L;
    private static final long DEFAULT_MAX_TIME_IN_BUFFER_MS = 5000L;
    private static final long DEFAULT_MAX_RECORD_SIZE_IN_B = 0x100000L;
    private static final boolean DEFAULT_FAIL_ON_ERROR = false;
    private Boolean failOnError;
    private String streamName;
    private Properties kinesisClientProperties;
    private SerializationSchema<InputT> serializationSchema;
    private PartitionKeyGenerator<InputT> partitionKeyGenerator;

    KinesisStreamsSinkBuilder() {
    }

    public KinesisStreamsSinkBuilder<InputT> setStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public KinesisStreamsSinkBuilder<InputT> setSerializationSchema(SerializationSchema<InputT> serializationSchema) {
        this.serializationSchema = serializationSchema;
        return this;
    }

    public KinesisStreamsSinkBuilder<InputT> setPartitionKeyGenerator(PartitionKeyGenerator<InputT> partitionKeyGenerator) {
        this.partitionKeyGenerator = partitionKeyGenerator;
        return this;
    }

    public KinesisStreamsSinkBuilder<InputT> setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public KinesisStreamsSinkBuilder<InputT> setKinesisClientProperties(Properties kinesisClientProperties) {
        this.kinesisClientProperties = kinesisClientProperties;
        return this;
    }

    public KinesisStreamsSink<InputT> build() {
        return new KinesisStreamsSink(new KinesisStreamsSinkElementConverter.Builder<InputT>().setSerializationSchema(this.serializationSchema).setPartitionKeyGenerator(this.partitionKeyGenerator).build(), Optional.ofNullable(this.getMaxBatchSize()).orElse(500), Optional.ofNullable(this.getMaxInFlightRequests()).orElse(50), Optional.ofNullable(this.getMaxBufferedRequests()).orElse(10000), Optional.ofNullable(this.getMaxBatchSizeInBytes()).orElse(0x500000L), Optional.ofNullable(this.getMaxTimeInBufferMS()).orElse(5000L), Optional.ofNullable(this.getMaxRecordSizeInBytes()).orElse(0x100000L), Optional.ofNullable(this.failOnError).orElse(false), this.streamName, Optional.ofNullable(this.kinesisClientProperties).orElse(new Properties()));
    }
}

