/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.util;

import java.net.URI;
import java.time.Duration;
import java.util.Properties;
import org.apache.flink.connector.aws.util.AWSClientUtil;
import org.apache.flink.connector.aws.util.TestUtil;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;

class AWSClientUtilTest {
    private static final String DEFAULT_USER_AGENT_PREFIX_FORMAT = "Apache Flink %s (%s) *Destination* Connector";
    private static final String DEFAULT_USER_AGENT_PREFIX_FORMAT_V2 = "Apache Flink %s (%s) *Destination* Connector V2";

    AWSClientUtilTest() {
    }

    @Test
    void testCreateKinesisAsyncClient() {
        Properties properties = TestUtil.properties("aws.region", "eu-west-2");
        MockAsyncClientBuilder builder = this.mockKinesisAsyncClientBuilder();
        ClientOverrideConfiguration clientOverrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().build();
        SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().build();
        AWSClientUtil.createAwsAsyncClient((Properties)properties, (AwsAsyncClientBuilder)builder, (SdkAsyncHttpClient)httpClient, (ClientOverrideConfiguration)clientOverrideConfiguration);
        ((MockAsyncClientBuilder)Mockito.verify((Object)builder)).overrideConfiguration(clientOverrideConfiguration);
        ((MockAsyncClientBuilder)Mockito.verify((Object)builder)).httpClient(httpClient);
        ((MockAsyncClientBuilder)Mockito.verify((Object)builder)).region(Region.of((String)"eu-west-2"));
        ((MockAsyncClientBuilder)Mockito.verify((Object)builder)).credentialsProvider((AwsCredentialsProvider)ArgumentMatchers.argThat(cp -> cp instanceof DefaultCredentialsProvider));
        ((MockAsyncClientBuilder)Mockito.verify((Object)builder, (VerificationMode)Mockito.never())).endpointOverride((URI)ArgumentMatchers.any());
    }

    @Test
    void testCreateKinesisAsyncClientWithEndpointOverride() {
        Properties properties = TestUtil.properties("aws.region", "eu-west-2");
        properties.setProperty("aws.endpoint", "https://localhost");
        MockAsyncClientBuilder builder = this.mockKinesisAsyncClientBuilder();
        ClientOverrideConfiguration clientOverrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().build();
        SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().build();
        AWSClientUtil.createAwsAsyncClient((Properties)properties, (AwsAsyncClientBuilder)builder, (SdkAsyncHttpClient)httpClient, (ClientOverrideConfiguration)clientOverrideConfiguration);
        ((MockAsyncClientBuilder)Mockito.verify((Object)builder)).endpointOverride(URI.create("https://localhost"));
    }

    @Test
    void testClientOverrideConfigurationWithDefaults() {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().build();
        ClientOverrideConfiguration.Builder builder = this.mockClientOverrideConfigurationBuilder();
        AWSClientUtil.createClientOverrideConfiguration((SdkClientConfiguration)clientConfiguration, (ClientOverrideConfiguration.Builder)builder, (String)AWSClientUtil.formatFlinkUserAgentPrefix((String)DEFAULT_USER_AGENT_PREFIX_FORMAT_V2));
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder)).build();
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder)).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)AWSClientUtil.formatFlinkUserAgentPrefix((String)DEFAULT_USER_AGENT_PREFIX_FORMAT_V2));
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder)).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, null);
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.never())).apiCallAttemptTimeout((Duration)ArgumentMatchers.any());
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.never())).apiCallTimeout((Duration)ArgumentMatchers.any());
    }

    @Test
    void testClientOverrideConfigurationUserAgentSuffix() {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().option((ClientOption)SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)"suffix").build();
        ClientOverrideConfiguration.Builder builder = this.mockClientOverrideConfigurationBuilder();
        AWSClientUtil.createClientOverrideConfiguration((SdkClientConfiguration)clientConfiguration, (ClientOverrideConfiguration.Builder)builder, (String)AWSClientUtil.formatFlinkUserAgentPrefix((String)DEFAULT_USER_AGENT_PREFIX_FORMAT_V2));
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder)).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)"suffix");
    }

    @Test
    void testClientOverrideConfigurationApiCallAttemptTimeout() {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.API_CALL_ATTEMPT_TIMEOUT, (Object)Duration.ofMillis(500L)).build();
        ClientOverrideConfiguration.Builder builder = this.mockClientOverrideConfigurationBuilder();
        AWSClientUtil.createClientOverrideConfiguration((SdkClientConfiguration)clientConfiguration, (ClientOverrideConfiguration.Builder)builder, (String)AWSClientUtil.formatFlinkUserAgentPrefix((String)"Apache Flink %s (%s) *Destination* Connector V2 V2"));
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder)).apiCallAttemptTimeout(Duration.ofMillis(500L));
    }

    @Test
    void testClientOverrideConfigurationApiCallTimeout() {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.API_CALL_TIMEOUT, (Object)Duration.ofMillis(600L)).build();
        ClientOverrideConfiguration.Builder builder = this.mockClientOverrideConfigurationBuilder();
        AWSClientUtil.createClientOverrideConfiguration((SdkClientConfiguration)clientConfiguration, (ClientOverrideConfiguration.Builder)builder, (String)AWSClientUtil.formatFlinkUserAgentPrefix((String)"Apache Flink %s (%s) *Destination* Connector V2 V2"));
        ((ClientOverrideConfiguration.Builder)Mockito.verify((Object)builder)).apiCallTimeout(Duration.ofMillis(600L));
    }

    private MockAsyncClientBuilder mockKinesisAsyncClientBuilder() {
        MockAsyncClientBuilder builder = (MockAsyncClientBuilder)Mockito.mock(MockAsyncClientBuilder.class);
        Mockito.when((Object)builder.overrideConfiguration((ClientOverrideConfiguration)ArgumentMatchers.any(ClientOverrideConfiguration.class))).thenReturn((Object)builder);
        Mockito.when((Object)builder.httpClient((SdkAsyncHttpClient)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.credentialsProvider((AwsCredentialsProvider)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.region((Region)ArgumentMatchers.any())).thenReturn((Object)builder);
        return builder;
    }

    private ClientOverrideConfiguration.Builder mockClientOverrideConfigurationBuilder() {
        ClientOverrideConfiguration.Builder builder = (ClientOverrideConfiguration.Builder)Mockito.mock(ClientOverrideConfiguration.Builder.class);
        Mockito.when((Object)builder.putAdvancedOption((SdkAdvancedClientOption)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.apiCallAttemptTimeout((Duration)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.apiCallTimeout((Duration)ArgumentMatchers.any())).thenReturn((Object)builder);
        return builder;
    }

    private static class MockAsyncClientBuilder
    implements AwsAsyncClientBuilder<MockAsyncClientBuilder, SdkClient>,
    AwsClientBuilder<MockAsyncClientBuilder, SdkClient> {
        private MockAsyncClientBuilder() {
        }

        public MockAsyncClientBuilder asyncConfiguration(ClientAsyncConfiguration clientAsyncConfiguration) {
            return null;
        }

        public MockAsyncClientBuilder httpClient(SdkAsyncHttpClient sdkAsyncHttpClient) {
            return null;
        }

        public MockAsyncClientBuilder httpClientBuilder(SdkAsyncHttpClient.Builder builder) {
            return null;
        }

        public MockAsyncClientBuilder credentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            return null;
        }

        public MockAsyncClientBuilder region(Region region) {
            return null;
        }

        public MockAsyncClientBuilder dualstackEnabled(Boolean aBoolean) {
            return null;
        }

        public MockAsyncClientBuilder fipsEnabled(Boolean aBoolean) {
            return null;
        }

        public MockAsyncClientBuilder overrideConfiguration(ClientOverrideConfiguration clientOverrideConfiguration) {
            return null;
        }

        public ClientOverrideConfiguration overrideConfiguration() {
            return null;
        }

        public MockAsyncClientBuilder endpointOverride(URI uri) {
            return null;
        }

        public SdkClient build() {
            return null;
        }
    }
}

