/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.sink.throwable;

import java.util.HashSet;
import org.apache.flink.connector.aws.sink.throwable.AWSExceptionHandler;
import org.apache.flink.connector.base.sink.throwable.FatalExceptionClassifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AWSExceptionHandlerTest {
    private final RuntimeException mappedException = new RuntimeException("AWSExceptionHandlerTest");
    private final AWSExceptionHandler exceptionHandler = AWSExceptionHandler.withClassifier((FatalExceptionClassifier)FatalExceptionClassifier.withRootCauseOfType(UnsupportedOperationException.class, err -> this.mappedException));

    @Test
    public void shouldReturnTrueIfFatal() {
        Assertions.assertTrue((boolean)this.exceptionHandler.consumeIfFatal((Throwable)new UnsupportedOperationException(), err -> {}));
    }

    @Test
    public void shouldReturnFalseIfNonFatal() {
        Assertions.assertFalse((boolean)this.exceptionHandler.consumeIfFatal((Throwable)new IndexOutOfBoundsException(), err -> {}));
    }

    @Test
    public void shouldConsumeMappedExceptionIfFatal() {
        HashSet consumedExceptions = new HashSet();
        Assertions.assertTrue((boolean)this.exceptionHandler.consumeIfFatal((Throwable)new UnsupportedOperationException(), consumedExceptions::add));
        Assertions.assertEquals((int)1, (int)consumedExceptions.size());
        Assertions.assertTrue((boolean)consumedExceptions.contains(this.mappedException));
    }

    @Test
    public void shouldNotConsumeMappedExceptionIfNonFatal() {
        Assertions.assertFalse((boolean)this.exceptionHandler.consumeIfFatal((Throwable)new IndexOutOfBoundsException(), err -> Assertions.assertTrue((boolean)false)));
    }
}

