/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.util;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.connector.aws.util.TestUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.ImmutableMap;

class AWSGeneralUtilTest {
    AWSGeneralUtilTest() {
    }

    @Test
    void testGetCredentialsProviderTypeDefaultsAuto() {
        Assertions.assertThat((Comparable)AWSGeneralUtil.getCredentialProviderType((Properties)new Properties(), (String)"aws.credentials.provider")).isEqualTo((Object)AWSConfigConstants.CredentialProvider.AUTO);
    }

    @Test
    void testGetCredentialsProviderTypeBasic() {
        Properties testConfig = TestUtil.properties(AWSConfigConstants.accessKeyId((String)"aws.credentials.provider"), "ak");
        testConfig.setProperty(AWSConfigConstants.secretKey((String)"aws.credentials.provider"), "sk");
        Assertions.assertThat((Comparable)AWSGeneralUtil.getCredentialProviderType((Properties)testConfig, (String)"aws.credentials.provider")).isEqualTo((Object)AWSConfigConstants.CredentialProvider.BASIC);
    }

    @Test
    void testGetCredentialsProviderTypeWebIdentityToken() {
        Properties testConfig = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        AWSConfigConstants.CredentialProvider type = AWSGeneralUtil.getCredentialProviderType((Properties)testConfig, (String)"aws.credentials.provider");
        Assertions.assertThat((Comparable)type).isEqualTo((Object)AWSConfigConstants.CredentialProvider.WEB_IDENTITY_TOKEN);
    }

    @Test
    void testGetCredentialsProviderTypeAssumeRole() {
        Properties testConfig = TestUtil.properties("aws.credentials.provider", "ASSUME_ROLE");
        AWSConfigConstants.CredentialProvider type = AWSGeneralUtil.getCredentialProviderType((Properties)testConfig, (String)"aws.credentials.provider");
        Assertions.assertThat((Comparable)type).isEqualTo((Object)AWSConfigConstants.CredentialProvider.ASSUME_ROLE);
    }

    @Test
    void testGetCredentialsProviderEnvironmentVariables() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "ENV_VAR");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(EnvironmentVariableCredentialsProvider.class);
    }

    @Test
    void testGetCredentialsProviderSystemProperties() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "SYS_PROP");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(SystemPropertyCredentialsProvider.class);
    }

    @Test
    void testGetCredentialsProviderWebIdentityTokenFileCredentialsProvider() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(WebIdentityTokenFileCredentialsProvider.class);
    }

    @Test
    void testGetWebIdentityTokenFileCredentialsProvider() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        properties.setProperty(AWSConfigConstants.roleArn((String)"aws.credentials.provider"), "roleArn");
        properties.setProperty(AWSConfigConstants.roleSessionName((String)"aws.credentials.provider"), "roleSessionName");
        WebIdentityTokenFileCredentialsProvider.Builder builder = this.mockWebIdentityTokenFileCredentialsProviderBuilder();
        AWSGeneralUtil.getWebIdentityTokenFileCredentialsProvider((WebIdentityTokenFileCredentialsProvider.Builder)builder, (Properties)properties, (String)"aws.credentials.provider");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder)).roleArn("roleArn");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder)).roleSessionName("roleSessionName");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.never())).webIdentityTokenFile((Path)ArgumentMatchers.any());
    }

    @Test
    void testGetWebIdentityTokenFileCredentialsProviderWithWebIdentityFile() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        properties.setProperty(AWSConfigConstants.webIdentityTokenFile((String)"aws.credentials.provider"), "webIdentityTokenFile");
        WebIdentityTokenFileCredentialsProvider.Builder builder = this.mockWebIdentityTokenFileCredentialsProviderBuilder();
        AWSGeneralUtil.getWebIdentityTokenFileCredentialsProvider((WebIdentityTokenFileCredentialsProvider.Builder)builder, (Properties)properties, (String)"aws.credentials.provider");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder)).webIdentityTokenFile(Paths.get("webIdentityTokenFile", new String[0]));
    }

    @Test
    void testGetCredentialsProviderAuto() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "AUTO");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(DefaultCredentialsProvider.class);
    }

    @Test
    void testGetCredentialsProviderFromMap() {
        ImmutableMap config = ImmutableMap.of((Object)"aws.credentials.provider", (Object)"AUTO");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Map)config);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(DefaultCredentialsProvider.class);
    }

    @Test
    void testGetCredentialsProviderAssumeRole() {
        Properties properties = (Properties)Mockito.spy((Object)TestUtil.properties("aws.credentials.provider", "ASSUME_ROLE"));
        properties.setProperty("aws.region", "eu-west-2");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(StsAssumeRoleCredentialsProvider.class);
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.roleArn((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.roleSessionName((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.externalId((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty("aws.region");
    }

    @Test
    void testGetCredentialsProviderAssumeRoleWithPropertyAwsStsEndpoint() {
        Properties properties = (Properties)Mockito.spy((Object)TestUtil.properties("aws.credentials.provider", "ASSUME_ROLE"));
        properties.setProperty("aws.region", "eu-west-2");
        properties.setProperty(AWSConfigConstants.AWS_ROLE_STS_ENDPOINT, "https://sts.eu-west-2.amazonaws.com");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(StsAssumeRoleCredentialsProvider.class);
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.roleArn((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.roleSessionName((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.externalId((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty("aws.region");
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.AWS_ROLE_STS_ENDPOINT);
    }

    @Test
    void testCustomCredentialProvider() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "CUSTOM");
        properties.setProperty("aws.region", "eu-west-2");
        properties.setProperty(AWSConfigConstants.CUSTOM_CREDENTIALS_PROVIDER_CLASS, "org.apache.flink.connector.aws.util.AWSGeneralUtilTest$MyCustomCredentialProvider");
        MyCustomCredentialProvider credentialsProvider = (MyCustomCredentialProvider)AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((String)credentialsProvider.myConfig.getProperty("aws.region")).isEqualTo("eu-west-2");
    }

    @Test
    void testCustomCredentialProviderWithBadCustomCredentialProviders() {
        Object credentialsProvider2;
        Properties properties = TestUtil.properties("aws.credentials.provider", "CUSTOM");
        try {
            properties.setProperty(AWSConfigConstants.CUSTOM_CREDENTIALS_PROVIDER_CLASS, "org.apache.flink.connector.aws.util.AWSGeneralUtilTest$MyCustomCredentialProviderMissingConstructor");
            credentialsProvider2 = (MyCustomCredentialProviderMissingConstructor)AWSGeneralUtil.getCredentialsProvider((Properties)properties);
            Assertions.fail((String)"Expected IllegalArgumentException to be thrown but did not catch any");
        }
        catch (RuntimeException credentialsProvider2) {
            // empty catch block
        }
        try {
            properties.setProperty(AWSConfigConstants.CUSTOM_CREDENTIALS_PROVIDER_CLASS, "org.apache.flink.connector.aws.util.AWSGeneralUtilTest$MyCustomCredentialProviderThatDoesNotImplementAwsCredentialsProvider");
            credentialsProvider2 = (MyCustomCredentialProviderThatDoesNotImplementAwsCredentialsProvider)AWSGeneralUtil.getCredentialsProvider((Properties)properties);
            Assertions.fail((String)"Expected ClassCastException to be thrown but did not catch any");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            AWSGeneralUtil.getCredentialsProvider((Properties)TestUtil.properties("aws.credentials.provider", "CUSTOM"));
            Assertions.fail((String)"Expected IllegalArgumentException to be thrown but did not catch any");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    void testGetCredentialsProviderBasic() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "BASIC");
        properties.setProperty(AWSConfigConstants.accessKeyId((String)"aws.credentials.provider"), "ak");
        properties.setProperty(AWSConfigConstants.secretKey((String)"aws.credentials.provider"), "sk");
        AwsCredentials credentials = AWSGeneralUtil.getCredentialsProvider((Properties)properties).resolveCredentials();
        Assertions.assertThat((String)credentials.accessKeyId()).isEqualTo("ak");
        Assertions.assertThat((String)credentials.secretAccessKey()).isEqualTo("sk");
    }

    @Test
    void testGetCredentialsProviderProfile() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "PROFILE");
        properties.put(AWSConfigConstants.profileName((String)"aws.credentials.provider"), "default");
        properties.put(AWSConfigConstants.profilePath((String)"aws.credentials.provider"), "src/test/resources/profile");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(ProfileCredentialsProvider.class);
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Assertions.assertThat((String)credentials.accessKeyId()).isEqualTo("11111111111111111111");
        Assertions.assertThat((String)credentials.secretAccessKey()).isEqualTo("wJalrXUtnFEMI/K7MDENG/bPxRfiCY1111111111");
    }

    @Test
    void testGetCredentialsProviderNamedProfile() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "PROFILE");
        properties.setProperty(AWSConfigConstants.profileName((String)"aws.credentials.provider"), "foo");
        properties.setProperty(AWSConfigConstants.profilePath((String)"aws.credentials.provider"), "src/test/resources/profile");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assertions.assertThat((Object)credentialsProvider).isInstanceOf(ProfileCredentialsProvider.class);
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Assertions.assertThat((String)credentials.accessKeyId()).isEqualTo("22222222222222222222");
        Assertions.assertThat((String)credentials.secretAccessKey()).isEqualTo("wJalrXUtnFEMI/K7MDENG/bPxRfiCY2222222222");
    }

    @Test
    void testCreateNettyAsyncHttpClientWithPropertyTcpKeepAlive() throws Exception {
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)new Properties());
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((boolean)nettyConfiguration.tcpKeepAlive()).isTrue();
    }

    @Test
    void testCreateNettyAsyncHttpClientWithPropertyMaxConcurrency() throws Exception {
        int maxConnections = 45678;
        Properties properties = new Properties();
        properties.setProperty("aws.http-client.max-concurrency", String.valueOf(maxConnections));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.maxConnections()).isEqualTo(maxConnections);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithPropertyReadTimeout() throws Exception {
        int readTimeoutMillis = 45678;
        Properties properties = new Properties();
        properties.setProperty("aws.http-client.read-timeout", String.valueOf(readTimeoutMillis));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.readTimeoutMillis()).isEqualTo(readTimeoutMillis);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithPropertyTrustAllCertificates() throws Exception {
        boolean trustAllCerts = true;
        Properties properties = new Properties();
        properties.setProperty("aws.trust.all.certificates", String.valueOf(trustAllCerts));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((boolean)nettyConfiguration.trustAllCertificates()).isEqualTo(trustAllCerts);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithPropertyProtocol() throws Exception {
        Protocol httpVersion = Protocol.HTTP1_1;
        Properties properties = new Properties();
        properties.setProperty("aws.http.protocol.version", String.valueOf(httpVersion));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((Comparable)((Protocol)nettyConfiguration.attribute((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL))).isEqualTo((Object)httpVersion);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsConnectionAcquireTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.connectionAcquireTimeoutMillis()).isEqualTo(60000);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsConnectionTtl() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((int)nettyConfiguration.connectionTtlMillis()).isEqualTo(nettyDefaultConfiguration.connectionTtlMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsConnectionTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((int)nettyDefaultConfiguration.connectTimeoutMillis()).isEqualTo(nettyConfiguration.connectTimeoutMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsIdleTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((int)nettyConfiguration.idleTimeoutMillis()).isEqualTo(nettyDefaultConfiguration.idleTimeoutMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsMaxConnections() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.maxConnections()).isEqualTo(10000);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsMaxPendingConnectionAcquires() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((int)nettyConfiguration.maxPendingConnectionAcquires()).isEqualTo(nettyDefaultConfiguration.maxPendingConnectionAcquires());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsReadTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.readTimeoutMillis()).isEqualTo(360000);
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsReapIdleConnections() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((boolean)nettyConfiguration.reapIdleConnections()).isEqualTo(nettyDefaultConfiguration.reapIdleConnections());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsTcpKeepAlive() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((boolean)nettyConfiguration.tcpKeepAlive()).isEqualTo(nettyDefaultConfiguration.tcpKeepAlive());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsTlsKeyManagersProvider() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((Object)nettyConfiguration.tlsKeyManagersProvider()).isEqualTo((Object)nettyDefaultConfiguration.tlsKeyManagersProvider());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsTlsTrustManagersProvider() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((Object)nettyConfiguration.tlsTrustManagersProvider()).isEqualTo((Object)nettyDefaultConfiguration.tlsTrustManagersProvider());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsTrustAllCertificates() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((boolean)nettyConfiguration.trustAllCertificates()).isFalse();
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsWriteTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assertions.assertThat((int)nettyConfiguration.writeTimeoutMillis()).isEqualTo(nettyDefaultConfiguration.writeTimeoutMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientWithDefaultsProtocol() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((Comparable)((Protocol)nettyConfiguration.attribute((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL))).isEqualTo((Object)Protocol.HTTP2);
    }

    @Test
    void testCreateNettyAsyncHttpClientReadTimeout() throws Exception {
        Duration readTimeout = Duration.ofMillis(1234L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)readTimeout).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.readTimeoutMillis()).isEqualTo(readTimeout.toMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientTcpKeepAlive() throws Exception {
        boolean tcpKeepAlive = true;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TCP_KEEPALIVE, (Object)tcpKeepAlive).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((boolean)nettyConfiguration.tcpKeepAlive()).isEqualTo(tcpKeepAlive);
    }

    @Test
    void testCreateNettyAsyncHttpClientConnectionTimeout() throws Exception {
        Duration connectionTimeout = Duration.ofMillis(1000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.connectTimeoutMillis()).isEqualTo(connectionTimeout.toMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientMaxConcurrency() throws Exception {
        int maxConnections = 123;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnections).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.maxConnections()).isEqualTo(maxConnections);
    }

    @Test
    void testCreateNettyAsyncHttpClientWriteTimeout() throws Exception {
        Duration writeTimeout = Duration.ofMillis(3000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.WRITE_TIMEOUT, (Object)writeTimeout).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.writeTimeoutMillis()).isEqualTo(writeTimeout.toMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientConnectionMaxIdleTime() throws Exception {
        Duration maxIdleTime = Duration.ofMillis(2000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)maxIdleTime).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.idleTimeoutMillis()).isEqualTo(maxIdleTime.toMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientIdleConnectionReaper() throws Exception {
        boolean reapIdleConnections = false;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS, (Object)reapIdleConnections).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((boolean)nettyConfiguration.reapIdleConnections()).isEqualTo(reapIdleConnections);
    }

    @Test
    void testCreateNettyAsyncHttpClientIdleConnectionTtl() throws Exception {
        Duration connectionTtl = Duration.ofMillis(5000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)connectionTtl).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((int)nettyConfiguration.connectionTtlMillis()).isEqualTo(connectionTtl.toMillis());
    }

    @Test
    void testCreateNettyAsyncHttpClientTrustAllCertificates() throws Exception {
        boolean trustAllCertificates = true;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)trustAllCertificates).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((boolean)nettyConfiguration.trustAllCertificates()).isEqualTo(trustAllCertificates);
    }

    @Test
    void testCreateNettyAsyncHttpClientHttpVersion() throws Exception {
        Protocol httpVersion = Protocol.HTTP1_1;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, (Object)httpVersion).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assertions.assertThat((Comparable)((Protocol)nettyConfiguration.attribute((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL))).isEqualTo((Object)httpVersion);
    }

    @Test
    void testGetRegion() {
        Region region = AWSGeneralUtil.getRegion((Properties)TestUtil.properties("aws.region", "eu-west-2"));
        Assertions.assertThat((Object)region).isEqualTo((Object)Region.EU_WEST_2);
    }

    @Test
    void testValidRegion() {
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"us-east-1"))).isTrue();
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"us-gov-west-1"))).isTrue();
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"us-isob-east-1"))).isTrue();
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"aws-global"))).isTrue();
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"aws-iso-global"))).isTrue();
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"aws-iso-b-global"))).isTrue();
    }

    @Test
    void testInvalidRegion() {
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"unstructured-string"))).isFalse();
    }

    @Test
    void testGetStsEndpoint() {
        String endpointValue = "https://sts.us-east-1.amazonaws.com";
        URI stsEndpoint = AWSGeneralUtil.getStsEndpoint((Properties)TestUtil.properties(AWSConfigConstants.AWS_ROLE_STS_ENDPOINT, endpointValue));
        Assertions.assertThat((URI)stsEndpoint).isEqualTo((Object)URI.create(endpointValue));
    }

    @Test
    void testUnrecognizableAwsRegionInConfig() {
        Properties testConfig = TestUtil.properties("aws.region", "wrongRegionId");
        testConfig.setProperty(AWSConfigConstants.AWS_ACCESS_KEY_ID, "accessKeyId");
        testConfig.setProperty(AWSConfigConstants.AWS_SECRET_ACCESS_KEY, "secretKey");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsConfiguration((Properties)testConfig)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid AWS region");
    }

    @Test
    void testCredentialProviderTypeSetToBasicButNoCredentialSetInConfig() {
        Properties testConfig = TestUtil.properties("aws.region", "us-east-1");
        testConfig.setProperty("aws.credentials.provider", "BASIC");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsConfiguration((Properties)testConfig)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Please set values for AWS Access Key ID ('" + AWSConfigConstants.AWS_ACCESS_KEY_ID + "') and Secret Key ('" + AWSConfigConstants.AWS_SECRET_ACCESS_KEY + "') when using the BASIC AWS credential provider type.");
    }

    @Test
    void testUnrecognizableCredentialProviderTypeInConfig() {
        Properties testConfig = TestUtil.getStandardProperties();
        testConfig.setProperty("aws.credentials.provider", "wrongProviderType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsConfiguration((Properties)testConfig)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid AWS Credential Provider Type");
    }

    @Test
    void testMissingWebIdentityTokenFileInCredentials() {
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsCredentials((Properties)properties)).isInstanceOf(IllegalStateException.class)).hasMessage("Either the environment variable AWS_WEB_IDENTITY_TOKEN_FILE or the javaproperty aws.webIdentityTokenFile must be set.");
    }

    @Test
    void testMissingEnvironmentVariableCredentials() {
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "ENV_VAR");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsCredentials((Properties)properties)).isInstanceOf(SdkClientException.class)).hasMessageContaining("Access key must be specified either via environment variable");
    }

    @Test
    void testFailedSystemPropertiesCredentialsValidationsOnMissingAccessKey() {
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "SYS_PROP");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsCredentials((Properties)properties)).isInstanceOf(SdkClientException.class)).hasMessageContaining("Access key must be specified either via environment variable (AWS_ACCESS_KEY_ID) or system property (aws.accessKeyId)");
    }

    @Test
    void testFailedSystemPropertiesCredentialsValidationsOnMissingSecretKey() {
        System.setProperty("aws.accessKeyId", "accesKeyId");
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "SYS_PROP");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AWSGeneralUtil.validateAwsCredentials((Properties)properties)).isInstanceOf(SdkClientException.class)).hasMessageContaining("Secret key must be specified either via environment variable (AWS_SECRET_ACCESS_KEY) or system property (aws.secretAccessKey)");
    }

    private WebIdentityTokenFileCredentialsProvider.Builder mockWebIdentityTokenFileCredentialsProviderBuilder() {
        WebIdentityTokenFileCredentialsProvider.Builder builder = (WebIdentityTokenFileCredentialsProvider.Builder)Mockito.mock(WebIdentityTokenFileCredentialsProvider.Builder.class);
        Mockito.when((Object)builder.roleArn((String)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.roleSessionName((String)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.webIdentityTokenFile((Path)ArgumentMatchers.any())).thenReturn((Object)builder);
        return builder;
    }

    public static class MyCustomCredentialProviderMissingConstructor
    implements AwsCredentialsProvider {
        public Properties myConfig;

        public AwsCredentials resolveCredentials() {
            return null;
        }
    }

    public static class MyCustomCredentialProviderThatDoesNotImplementAwsCredentialsProvider {
        public Properties myConfig;

        public MyCustomCredentialProviderThatDoesNotImplementAwsCredentialsProvider(Properties config) {
            this.myConfig = config;
        }
    }

    public static class MyCustomCredentialProvider
    implements AwsCredentialsProvider {
        public Properties myConfig;

        public MyCustomCredentialProvider(Properties config) {
            this.myConfig = config;
        }

        public AwsCredentials resolveCredentials() {
            return null;
        }
    }
}

