/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.testutils;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.connector.aws.testutils.AWSServicesTestUtils;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Object;

public class LocalstackContainer
extends GenericContainer<LocalstackContainer> {
    private static final int CONTAINER_PORT = 4566;

    public LocalstackContainer(DockerImageName imageName) {
        super(imageName);
        this.withExposedPorts(new Integer[]{4566});
        this.waitingFor((WaitStrategy)new ListBucketObjectsWaitStrategy());
    }

    public String getEndpoint() {
        return String.format("https://%s:%s", this.getHost(), this.getMappedPort(4566));
    }

    private class ListBucketObjectsWaitStrategy
    extends AbstractWaitStrategy {
        private static final int TRANSACTIONS_PER_SECOND = 1;
        private final RateLimiter rateLimiter = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();

        private ListBucketObjectsWaitStrategy() {
        }

        protected void waitUntilReady() {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new IllegalStateException("Localstack Container startup was interrupted");
            }
            Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> (List)this.rateLimiter.getWhenReady(this::list));
        }

        private List<S3Object> list() {
            String bucketName = "bucket-name-not-to-be-used";
            try (SdkHttpClient httpClient = AWSServicesTestUtils.createHttpClient();){
                List<S3Object> list;
                block12: {
                    S3Client client = AWSServicesTestUtils.createS3Client(LocalstackContainer.this.getEndpoint(), httpClient);
                    try {
                        AWSServicesTestUtils.createBucket(client, "bucket-name-not-to-be-used");
                        list = AWSServicesTestUtils.listBucketObjects(client, "bucket-name-not-to-be-used");
                        if (client == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    client.close();
                }
                return list;
            }
        }
    }
}

