/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.table.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.connector.aws.table.util.AWSOptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AWSOptionsUtilTest {
    AWSOptionsUtilTest() {
    }

    @Test
    void testAWSKeyMapper() {
        AWSOptionUtils awsOptionUtils = new AWSOptionUtils(this.getDefaultAWSConfigurations());
        Map<String, String> expectedProperties = this.getDefaultExpectedAWSConfigurations();
        Map actualMappedProperties = awsOptionUtils.getProcessedResolvedOptions();
        Assertions.assertThat((Map)actualMappedProperties).isEqualTo(expectedProperties);
    }

    @Test
    void testAWSKeySelectionAndMapping() {
        Map<String, String> resolvedTableOptions = this.getDefaultAWSConfigurations();
        Map<String, String> expectedProperties = this.getDefaultExpectedAWSConfigurations();
        resolvedTableOptions.put("non.aws.key1", "value1");
        resolvedTableOptions.put("non.aws.key2", "value2");
        resolvedTableOptions.put("non.aws.key3", "value3");
        resolvedTableOptions.put("non.aws.key4", "value4");
        AWSOptionUtils awsOptionUtils = new AWSOptionUtils(resolvedTableOptions);
        Map actualMappedProperties = awsOptionUtils.getProcessedResolvedOptions();
        Assertions.assertThat((Map)actualMappedProperties).isEqualTo(expectedProperties);
    }

    @Test
    void testGoodAWSProperties() {
        AWSOptionUtils awsOptionUtils = new AWSOptionUtils(this.getDefaultAWSConfigurations());
        Properties expectedProperties = new Properties();
        expectedProperties.putAll(this.getDefaultExpectedAWSConfigurations());
        Properties actualProperties = awsOptionUtils.getValidatedConfigurations();
        Assertions.assertThat((Map)actualProperties).isEqualTo((Object)expectedProperties);
    }

    @Test
    void testBadAWSRegion() {
        Map<String, String> defaultProperties = this.getDefaultAWSConfigurations();
        defaultProperties.put("aws.region", "invalid-aws-region");
        AWSOptionUtils awsOptionUtils = new AWSOptionUtils(defaultProperties);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((AWSOptionUtils)awsOptionUtils).getValidatedConfigurations()).withMessageContaining("Invalid AWS region set in config.");
    }

    @Test
    void testMissingAWSCredentials() {
        Map<String, String> defaultProperties = this.getDefaultAWSConfigurations();
        defaultProperties.remove("aws.credentials.basic.accesskeyid");
        AWSOptionUtils awsOptionUtils = new AWSOptionUtils(defaultProperties);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((AWSOptionUtils)awsOptionUtils).getValidatedConfigurations()).withMessageContaining(String.format("Please set values for AWS Access Key ID ('%s') and Secret Key ('%s') when using the BASIC AWS credential provider type.", AWSConfigConstants.AWS_ACCESS_KEY_ID, AWSConfigConstants.AWS_SECRET_ACCESS_KEY));
    }

    @Test
    void testInvalidTrustAllCertificatesOption() {
        Map<String, String> defaultProperties = this.getDefaultAWSConfigurations();
        defaultProperties.put("aws.trust.all.certificates", "invalid-boolean");
        AWSOptionUtils awsOptionUtils = new AWSOptionUtils(defaultProperties);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((AWSOptionUtils)awsOptionUtils).getValidatedConfigurations()).withMessageContaining(String.format("Invalid %s value, must be a boolean.", "aws.trust.all.certificates"));
    }

    private Map<String, String> getDefaultAWSConfigurations() {
        HashMap<String, String> defaultAWSConfigurations = new HashMap<String, String>();
        defaultAWSConfigurations.put("aws.region", "us-west-2");
        defaultAWSConfigurations.put("aws.credentials.provider", "BASIC");
        defaultAWSConfigurations.put("aws.credentials.basic.accesskeyid", "ververicka");
        defaultAWSConfigurations.put("aws.credentials.basic.secretkey", "SuperSecretSecretSquirrel");
        defaultAWSConfigurations.put("aws.trust.all.certificates", "true");
        return defaultAWSConfigurations;
    }

    private Map<String, String> getDefaultExpectedAWSConfigurations() {
        HashMap<String, String> defaultExpectedAWSConfigurations = new HashMap<String, String>();
        defaultExpectedAWSConfigurations.put("aws.region", "us-west-2");
        defaultExpectedAWSConfigurations.put("aws.credentials.provider", "BASIC");
        defaultExpectedAWSConfigurations.put("aws.credentials.provider.basic.accesskeyid", "ververicka");
        defaultExpectedAWSConfigurations.put("aws.credentials.provider.basic.secretkey", "SuperSecretSecretSquirrel");
        defaultExpectedAWSConfigurations.put("aws.trust.all.certificates", "true");
        return defaultExpectedAWSConfigurations;
    }
}

