/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.sink.throwable;

import java.util.HashSet;
import org.apache.flink.connector.aws.sink.throwable.AWSExceptionClassifierUtil;
import org.apache.flink.connector.base.sink.throwable.FatalExceptionClassifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sts.model.StsException;

public class AWSExceptionClassifierUtilTest {
    @Test
    public void shouldCreateFatalExceptionClassifierThatClassifiesAsFatalIfMatchingErrorCode() {
        AwsServiceException exception = StsException.builder().awsErrorDetails(AwsErrorDetails.builder().errorCode("NotAuthorizedException").build()).build();
        FatalExceptionClassifier classifier = AWSExceptionClassifierUtil.withAWSServiceErrorCode(StsException.class, (String)"NotAuthorizedException", err -> new RuntimeException());
        boolean isFatal = !classifier.isFatal((Throwable)exception, err -> {});
        Assertions.assertTrue((boolean)isFatal);
    }

    @Test
    public void shouldCreateFatalExceptionClassifierThatClassifiesAsNonFatalIfNotMatchingErrorCode() {
        AwsServiceException exception = StsException.builder().awsErrorDetails(AwsErrorDetails.builder().errorCode("SomeOtherException").build()).build();
        FatalExceptionClassifier classifier = AWSExceptionClassifierUtil.withAWSServiceErrorCode(StsException.class, (String)"NotAuthorizedException", err -> new RuntimeException());
        boolean isFatal = !classifier.isFatal((Throwable)exception, err -> {});
        Assertions.assertFalse((boolean)isFatal);
    }

    @Test
    public void shouldCreateFatalExceptionClassifierThatAppliesThrowableMapper() {
        AwsServiceException exception = StsException.builder().awsErrorDetails(AwsErrorDetails.builder().errorCode("NotAuthorizedException").build()).build();
        RuntimeException mappedException = new RuntimeException("shouldCreateFatalExceptionClassifierThatAppliesThrowableMapper");
        FatalExceptionClassifier classifier = AWSExceptionClassifierUtil.withAWSServiceErrorCode(StsException.class, (String)"NotAuthorizedException", err -> mappedException);
        HashSet consumedExceptions = new HashSet();
        classifier.isFatal((Throwable)exception, consumedExceptions::add);
        Assertions.assertEquals((int)1, (int)consumedExceptions.size());
        Assertions.assertTrue((boolean)consumedExceptions.contains(mappedException));
    }
}

