/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.tools.ci.licensecheck;

import java.io.File;
import java.nio.file.Paths;
import org.apache.flink.tools.ci.licensecheck.JarFileChecker;
import org.apache.flink.tools.ci.licensecheck.NoticeFileChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseChecker.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: LicenseChecker <pathMavenBuildOutput> <pathFlinkRoot> <pathFlinkDeployed>");
            System.exit(1);
        }
        LOG.warn("THIS UTILITY IS ONLY CHECKING FOR COMMON LICENSING MISTAKES. A MANUAL CHECK OF THE NOTICE FILES, DEPLOYED ARTIFACTS, ETC. IS STILL NEEDED!");
        int severeIssueCount = NoticeFileChecker.run(new File(args[0]), Paths.get(args[1], new String[0]));
        if ((severeIssueCount += JarFileChecker.checkPath(Paths.get(args[2], new String[0]))) > 0) {
            LOG.warn("Found a total of {} severe license issues", (Object)severeIssueCount);
            System.exit(1);
        }
        LOG.info("License check completed without severe issues.");
    }
}

