/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import java.io.PrintStream;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.apache.flink.fs.azure.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.GSet;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class LightWeightGSet<K, E extends K>
implements GSet<K, E> {
    static final int MAX_ARRAY_LENGTH = 0x40000000;
    static final int MIN_ARRAY_LENGTH = 1;
    protected LinkedElement[] entries;
    protected int hash_mask;
    protected int size = 0;
    protected int modification = 0;
    private Collection<E> values;

    protected LightWeightGSet() {
    }

    public LightWeightGSet(int recommended_length) {
        int actual = LightWeightGSet.actualArrayLength(recommended_length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("recommended=" + recommended_length + ", actual=" + actual);
        }
        this.entries = new LinkedElement[actual];
        this.hash_mask = this.entries.length - 1;
    }

    protected static int actualArrayLength(int recommended) {
        if (recommended > 0x40000000) {
            return 0x40000000;
        }
        if (recommended < 1) {
            return 1;
        }
        int a = Integer.highestOneBit(recommended);
        return a == recommended ? a : a << 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected int getIndex(K key) {
        return key.hashCode() & this.hash_mask;
    }

    protected E convert(LinkedElement e) {
        LinkedElement r = e;
        return (E)r;
    }

    @Override
    public E get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int index = this.getIndex(key);
        for (LinkedElement e = this.entries[index]; e != null; e = e.getNext()) {
            if (!e.equals(key)) continue;
            return this.convert(e);
        }
        return null;
    }

    @Override
    public boolean contains(K key) {
        return this.get(key) != null;
    }

    @Override
    public E put(E element) {
        if (element == null) {
            throw new NullPointerException("Null element is not supported.");
        }
        LinkedElement e = null;
        try {
            e = (LinkedElement)element;
        }
        catch (ClassCastException ex) {
            throw new HadoopIllegalArgumentException("!(element instanceof LinkedElement), element.getClass()=" + element.getClass());
        }
        int index = this.getIndex(element);
        E existing = this.remove(index, element);
        ++this.modification;
        ++this.size;
        e.setNext(this.entries[index]);
        this.entries[index] = e;
        return existing;
    }

    protected E remove(int index, K key) {
        if (this.entries[index] == null) {
            return null;
        }
        if (this.entries[index].equals(key)) {
            ++this.modification;
            --this.size;
            LinkedElement e = this.entries[index];
            this.entries[index] = e.getNext();
            e.setNext(null);
            return this.convert(e);
        }
        LinkedElement prev = this.entries[index];
        for (LinkedElement curr = prev.getNext(); curr != null; curr = curr.getNext()) {
            if (curr.equals(key)) {
                ++this.modification;
                --this.size;
                prev.setNext(curr.getNext());
                curr.setNext(null);
                return this.convert(curr);
            }
            prev = curr;
        }
        return null;
    }

    @Override
    public E remove(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.remove(this.getIndex(key), key);
    }

    @Override
    public Collection<E> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Iterator<E> iterator() {
        return new SetIterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("(size=").append(this.size).append(String.format(", %08x", this.hash_mask)).append(", modification=").append(this.modification).append(", entries.length=").append(this.entries.length).append(")");
        return b.toString();
    }

    public void printDetails(PrintStream out) {
        out.print(this + ", entries = [");
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            LinkedElement e = this.entries[i];
            out.print("\n  " + i + ": " + e);
            for (e = e.getNext(); e != null; e = e.getNext()) {
                out.print(" -> " + e);
            }
        }
        out.println("\n]");
    }

    public static int computeCapacity(double percentage, String mapName) {
        return LightWeightGSet.computeCapacity(Runtime.getRuntime().maxMemory(), percentage, mapName);
    }

    @VisibleForTesting
    static int computeCapacity(long maxMemory, double percentage, String mapName) {
        if (percentage > 100.0 || percentage < 0.0) {
            throw new HadoopIllegalArgumentException("Percentage " + percentage + " must be greater than or equal to 0  and less than or equal to 100");
        }
        if (maxMemory < 0L) {
            throw new HadoopIllegalArgumentException("Memory " + maxMemory + " must be greater than or equal to 0");
        }
        if (percentage == 0.0 || maxMemory == 0L) {
            return 0;
        }
        String vmBit = System.getProperty("sun.arch.data.model");
        double percentDivisor = 100.0 / percentage;
        double percentMemory = (double)maxMemory / percentDivisor;
        int e1 = (int)(Math.log(percentMemory) / Math.log(2.0) + 0.5);
        int e2 = e1 - ("32".equals(vmBit) ? 2 : 3);
        int exponent = e2 < 0 ? 0 : (e2 > 30 ? 30 : e2);
        int c = 1 << exponent;
        LOG.info("Computing capacity for map " + mapName);
        LOG.info("VM type       = " + vmBit + "-bit");
        LOG.info(percentage + "% max memory " + StringUtils.TraditionalBinaryPrefix.long2String(maxMemory, "B", 1) + " = " + StringUtils.TraditionalBinaryPrefix.long2String((long)percentMemory, "B", 1));
        LOG.info("capacity      = 2^" + exponent + " = " + c + " entries");
        return c;
    }

    @Override
    public void clear() {
        ++this.modification;
        Arrays.fill(this.entries, null);
        this.size = 0;
    }

    public class SetIterator
    implements Iterator<E> {
        private int iterModification;
        private int index;
        private LinkedElement cur;
        private LinkedElement next;
        private boolean trackModification;

        public SetIterator() {
            this.iterModification = LightWeightGSet.this.modification;
            this.index = -1;
            this.cur = null;
            this.next = this.nextNonemptyEntry();
            this.trackModification = true;
        }

        private LinkedElement nextNonemptyEntry() {
            ++this.index;
            while (this.index < LightWeightGSet.this.entries.length && LightWeightGSet.this.entries[this.index] == null) {
                ++this.index;
            }
            return this.index < LightWeightGSet.this.entries.length ? LightWeightGSet.this.entries[this.index] : null;
        }

        private void ensureNext() {
            if (this.trackModification && LightWeightGSet.this.modification != this.iterModification) {
                throw new ConcurrentModificationException("modification=" + LightWeightGSet.this.modification + " != iterModification = " + this.iterModification);
            }
            if (this.next != null) {
                return;
            }
            if (this.cur == null) {
                return;
            }
            this.next = this.cur.getNext();
            if (this.next == null) {
                this.next = this.nextNonemptyEntry();
            }
        }

        @Override
        public boolean hasNext() {
            this.ensureNext();
            return this.next != null;
        }

        @Override
        public E next() {
            this.ensureNext();
            if (this.next == null) {
                throw new IllegalStateException("There are no more elements");
            }
            this.cur = this.next;
            this.next = null;
            return LightWeightGSet.this.convert(this.cur);
        }

        @Override
        public void remove() {
            this.ensureNext();
            if (this.cur == null) {
                throw new IllegalStateException("There is no current element to remove");
            }
            LightWeightGSet.this.remove(this.cur);
            ++this.iterModification;
            this.cur = null;
        }

        public void setTrackModification(boolean trackModification) {
            this.trackModification = trackModification;
        }
    }

    private final class Values
    extends AbstractCollection<E> {
        private Values() {
        }

        @Override
        public Iterator<E> iterator() {
            return LightWeightGSet.this.iterator();
        }

        @Override
        public int size() {
            return LightWeightGSet.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LightWeightGSet.this.contains(o);
        }

        @Override
        public void clear() {
            LightWeightGSet.this.clear();
        }
    }

    public static interface LinkedElement {
        public void setNext(LinkedElement var1);

        public LinkedElement getNext();
    }
}

