/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flink.fs.azure.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.InstrumentedLock;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Timer;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InstrumentedReadLock
extends InstrumentedLock {
    private final ReentrantReadWriteLock readWriteLock;
    private final ThreadLocal<Long> readLockHeldTimeStamp = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return Long.MAX_VALUE;
        }
    };

    public InstrumentedReadLock(String name, Logger logger, ReentrantReadWriteLock readWriteLock, long minLoggingGapMs, long lockWarningThresholdMs) {
        this(name, logger, readWriteLock, minLoggingGapMs, lockWarningThresholdMs, new Timer());
    }

    @VisibleForTesting
    InstrumentedReadLock(String name, Logger logger, ReentrantReadWriteLock readWriteLock, long minLoggingGapMs, long lockWarningThresholdMs, Timer clock) {
        super(name, logger, readWriteLock.readLock(), minLoggingGapMs, lockWarningThresholdMs, clock);
        this.readWriteLock = readWriteLock;
    }

    @Override
    public void unlock() {
        boolean needReport = this.readWriteLock.getReadHoldCount() == 1;
        long localLockReleaseTime = this.getTimer().monotonicNow();
        long localLockAcquireTime = this.readLockHeldTimeStamp.get();
        this.getLock().unlock();
        if (needReport) {
            this.readLockHeldTimeStamp.remove();
            this.check(localLockAcquireTime, localLockReleaseTime);
        }
    }

    @Override
    protected void startLockTiming() {
        if (this.readWriteLock.getReadHoldCount() == 1) {
            this.readLockHeldTimeStamp.set(this.getTimer().monotonicNow());
        }
    }
}

