/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import java.math.BigInteger;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CpuTimeTracker {
    public static final int UNAVAILABLE = -1;
    private final long minimumTimeInterval;
    private BigInteger cumulativeCpuTime = BigInteger.ZERO;
    private BigInteger lastCumulativeCpuTime = BigInteger.ZERO;
    private long sampleTime;
    private long lastSampleTime;
    private float cpuUsage;
    private BigInteger jiffyLengthInMillis;

    public CpuTimeTracker(long jiffyLengthInMillis) {
        this.jiffyLengthInMillis = BigInteger.valueOf(jiffyLengthInMillis);
        this.cpuUsage = -1.0f;
        this.sampleTime = -1L;
        this.lastSampleTime = -1L;
        this.minimumTimeInterval = 10L * jiffyLengthInMillis;
    }

    public float getCpuTrackerUsagePercent() {
        if (this.lastSampleTime == -1L || this.lastSampleTime > this.sampleTime) {
            this.lastSampleTime = this.sampleTime;
            this.lastCumulativeCpuTime = this.cumulativeCpuTime;
            return this.cpuUsage;
        }
        if (this.sampleTime > this.lastSampleTime + this.minimumTimeInterval) {
            this.cpuUsage = this.cumulativeCpuTime.subtract(this.lastCumulativeCpuTime).floatValue() * 100.0f / (float)(this.sampleTime - this.lastSampleTime);
            this.lastSampleTime = this.sampleTime;
            this.lastCumulativeCpuTime = this.cumulativeCpuTime;
        }
        return this.cpuUsage;
    }

    public long getCumulativeCpuTime() {
        return this.cumulativeCpuTime.longValue();
    }

    public void updateElapsedJiffies(BigInteger elapsedJiffies, long newTime) {
        BigInteger newValue = elapsedJiffies.multiply(this.jiffyLengthInMillis);
        this.cumulativeCpuTime = newValue.compareTo(this.cumulativeCpuTime) >= 0 ? newValue : this.cumulativeCpuTime;
        this.sampleTime = newTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SampleTime " + this.sampleTime);
        sb.append(" CummulativeCpuTime " + this.cumulativeCpuTime);
        sb.append(" LastSampleTime " + this.lastSampleTime);
        sb.append(" LastCummulativeCpuTime " + this.lastCumulativeCpuTime);
        sb.append(" CpuUsage " + this.cpuUsage);
        sb.append(" JiffyLengthMillisec " + this.jiffyLengthInMillis);
        return sb.toString();
    }
}

