/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.CacheableIPList;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.FileBasedIPList;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.IPList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedIPList
implements IPList {
    public static final Logger LOG = LoggerFactory.getLogger(CombinedIPList.class);
    private final IPList[] networkLists;

    public CombinedIPList(String fixedBlackListFile, String variableBlackListFile, long cacheExpiryInSeconds) {
        FileBasedIPList fixedNetworkList = new FileBasedIPList(fixedBlackListFile);
        if (variableBlackListFile != null) {
            CacheableIPList variableNetworkList = new CacheableIPList(new FileBasedIPList(variableBlackListFile), cacheExpiryInSeconds);
            this.networkLists = new IPList[]{fixedNetworkList, variableNetworkList};
        } else {
            this.networkLists = new IPList[]{fixedNetworkList};
        }
    }

    @Override
    public boolean isIn(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("ipAddress is null");
        }
        for (IPList networkList : this.networkLists) {
            if (!networkList.isIn(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

