/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.FileBasedIPList;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.IPList;

public class CacheableIPList
implements IPList {
    private final long cacheTimeout;
    private volatile long cacheExpiryTimeStamp;
    private volatile FileBasedIPList ipList;

    public CacheableIPList(FileBasedIPList ipList, long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
        this.ipList = ipList;
        this.updateCacheExpiryTime();
    }

    private void reset() {
        this.ipList = this.ipList.reload();
        this.updateCacheExpiryTime();
    }

    private void updateCacheExpiryTime() {
        this.cacheExpiryTimeStamp = this.cacheTimeout < 0L ? -1L : System.currentTimeMillis() + this.cacheTimeout;
    }

    public void refresh() {
        this.cacheExpiryTimeStamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIn(String ipAddress) {
        if (this.cacheExpiryTimeStamp >= 0L && this.cacheExpiryTimeStamp < System.currentTimeMillis()) {
            CacheableIPList cacheableIPList = this;
            synchronized (cacheableIPList) {
                if (this.cacheExpiryTimeStamp < System.currentTimeMillis()) {
                    this.reset();
                }
            }
        }
        return this.ipList.isIn(ipAddress);
    }
}

