/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayEncodingState;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.EncodingState;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
class ByteBufferEncodingState
extends EncodingState {
    ByteBuffer[] inputs;
    ByteBuffer[] outputs;
    boolean usingDirectBuffer;

    ByteBufferEncodingState(RawErasureEncoder encoder, ByteBuffer[] inputs, ByteBuffer[] outputs) {
        this.encoder = encoder;
        ByteBuffer validInput = CoderUtil.findFirstValidInput(inputs);
        this.encodeLength = validInput.remaining();
        this.usingDirectBuffer = validInput.isDirect();
        this.inputs = inputs;
        this.outputs = outputs;
        this.checkParameters(inputs, outputs);
        this.checkBuffers(inputs);
        this.checkBuffers(outputs);
    }

    ByteBufferEncodingState(RawErasureEncoder encoder, int encodeLength, ByteBuffer[] inputs, ByteBuffer[] outputs) {
        this.encoder = encoder;
        this.encodeLength = encodeLength;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    ByteArrayEncodingState convertToByteArrayState() {
        ByteBuffer buffer;
        int i;
        int[] inputOffsets = new int[this.inputs.length];
        int[] outputOffsets = new int[this.outputs.length];
        byte[][] newInputs = new byte[this.inputs.length][];
        byte[][] newOutputs = new byte[this.outputs.length][];
        for (i = 0; i < this.inputs.length; ++i) {
            buffer = this.inputs[i];
            inputOffsets[i] = buffer.arrayOffset() + buffer.position();
            newInputs[i] = buffer.array();
        }
        for (i = 0; i < this.outputs.length; ++i) {
            buffer = this.outputs[i];
            outputOffsets[i] = buffer.arrayOffset() + buffer.position();
            newOutputs[i] = buffer.array();
        }
        ByteArrayEncodingState baeState = new ByteArrayEncodingState(this.encoder, this.encodeLength, newInputs, inputOffsets, newOutputs, outputOffsets);
        return baeState;
    }

    void checkBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) {
                throw new HadoopIllegalArgumentException("Invalid buffer found, not allowing null");
            }
            if (buffer.remaining() != this.encodeLength) {
                throw new HadoopIllegalArgumentException("Invalid buffer, not of length " + this.encodeLength);
            }
            if (buffer.isDirect() == this.usingDirectBuffer) continue;
            throw new HadoopIllegalArgumentException("Invalid buffer, isDirect should be " + this.usingDirectBuffer);
        }
    }
}

