/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DataOutputByteBuffer
extends DataOutputStream {
    private final Buffer buffers;

    public DataOutputByteBuffer() {
        this(32);
    }

    public DataOutputByteBuffer(int size) {
        this(size, false);
    }

    public DataOutputByteBuffer(int size, boolean direct) {
        this(new Buffer(size, direct));
    }

    private DataOutputByteBuffer(Buffer buffers) {
        super(buffers);
        this.buffers = buffers;
    }

    public ByteBuffer[] getData() {
        return this.buffers.getData();
    }

    public int getLength() {
        return this.buffers.getLength();
    }

    public void reset() {
        this.written = 0;
        this.buffers.reset();
    }

    static class Buffer
    extends OutputStream {
        final byte[] b = new byte[1];
        final boolean direct;
        final List<ByteBuffer> active = new ArrayList<ByteBuffer>();
        final List<ByteBuffer> inactive = new LinkedList<ByteBuffer>();
        int size;
        int length;
        ByteBuffer current;

        Buffer(int size, boolean direct) {
            this.direct = direct;
            this.size = size;
            this.current = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        }

        @Override
        public void write(int b) {
            this.b[0] = (byte)(b & 0xFF);
            this.write(this.b);
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            int rem = this.current.remaining();
            while (len > rem) {
                this.current.put(b, off, rem);
                this.length += rem;
                this.current.flip();
                this.active.add(this.current);
                off += rem;
                rem = this.getBuffer(len -= rem);
            }
            this.current.put(b, off, len);
            this.length += len;
        }

        int getBuffer(int newsize) {
            if (this.inactive.isEmpty()) {
                this.size = Math.max(this.size << 1, newsize);
                this.current = this.direct ? ByteBuffer.allocateDirect(this.size) : ByteBuffer.allocate(this.size);
            } else {
                this.current = this.inactive.remove(0);
            }
            return this.current.remaining();
        }

        ByteBuffer[] getData() {
            ByteBuffer[] ret = this.active.toArray(new ByteBuffer[this.active.size() + 1]);
            ByteBuffer tmp = this.current.duplicate();
            tmp.flip();
            ret[ret.length - 1] = tmp.slice();
            return ret;
        }

        int getLength() {
            return this.length;
        }

        void reset() {
            this.length = 0;
            this.current.rewind();
            this.inactive.add(0, this.current);
            for (int i = this.active.size() - 1; i >= 0; --i) {
                ByteBuffer b = this.active.remove(i);
                b.rewind();
                this.inactive.add(0, b);
            }
            this.current = this.inactive.remove(0);
        }
    }
}

