/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.metrics;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.metrics.RollingWindowAverage;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsSource;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Metrics for WASB", context="azureFileSystem")
@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class AzureFileSystemInstrumentation
implements MetricsSource {
    public static final String METRIC_TAG_FILESYSTEM_ID = "wasbFileSystemId";
    public static final String METRIC_TAG_ACCOUNT_NAME = "accountName";
    public static final String METRIC_TAG_CONTAINTER_NAME = "containerName";
    public static final String WASB_WEB_RESPONSES = "wasb_web_responses";
    public static final String WASB_BYTES_WRITTEN = "wasb_bytes_written_last_second";
    public static final String WASB_BYTES_READ = "wasb_bytes_read_last_second";
    public static final String WASB_RAW_BYTES_UPLOADED = "wasb_raw_bytes_uploaded";
    public static final String WASB_RAW_BYTES_DOWNLOADED = "wasb_raw_bytes_downloaded";
    public static final String WASB_FILES_CREATED = "wasb_files_created";
    public static final String WASB_FILES_DELETED = "wasb_files_deleted";
    public static final String WASB_DIRECTORIES_CREATED = "wasb_directories_created";
    public static final String WASB_DIRECTORIES_DELETED = "wasb_directories_deleted";
    public static final String WASB_UPLOAD_RATE = "wasb_maximum_upload_bytes_per_second";
    public static final String WASB_DOWNLOAD_RATE = "wasb_maximum_download_bytes_per_second";
    public static final String WASB_UPLOAD_LATENCY = "wasb_average_block_upload_latency_ms";
    public static final String WASB_DOWNLOAD_LATENCY = "wasb_average_block_download_latency_ms";
    public static final String WASB_CLIENT_ERRORS = "wasb_client_errors";
    public static final String WASB_SERVER_ERRORS = "wasb_server_errors";
    private static final String KEY_ROLLING_WINDOW_SIZE = "fs.azure.metrics.rolling.window.size";
    private final MetricsRegistry registry = new MetricsRegistry("azureFileSystem").setContext("azureFileSystem");
    private final MutableCounterLong numberOfWebResponses = this.registry.newCounter("wasb_web_responses", "Total number of web responses obtained from Azure Storage", 0L);
    private AtomicLong inMemoryNumberOfWebResponses = new AtomicLong(0L);
    private final MutableCounterLong numberOfFilesCreated = this.registry.newCounter("wasb_files_created", "Total number of files created through the WASB file system.", 0L);
    private final MutableCounterLong numberOfFilesDeleted = this.registry.newCounter("wasb_files_deleted", "Total number of files deleted through the WASB file system.", 0L);
    private final MutableCounterLong numberOfDirectoriesCreated = this.registry.newCounter("wasb_directories_created", "Total number of directories created through the WASB file system.", 0L);
    private final MutableCounterLong numberOfDirectoriesDeleted = this.registry.newCounter("wasb_directories_deleted", "Total number of directories deleted through the WASB file system.", 0L);
    private final MutableGaugeLong bytesWrittenInLastSecond = this.registry.newGauge("wasb_bytes_written_last_second", "Total number of bytes written to Azure Storage during the last second.", 0L);
    private final MutableGaugeLong bytesReadInLastSecond = this.registry.newGauge("wasb_bytes_read_last_second", "Total number of bytes read from Azure Storage during the last second.", 0L);
    private final MutableGaugeLong maximumUploadBytesPerSecond = this.registry.newGauge("wasb_maximum_upload_bytes_per_second", "The maximum upload rate encountered to Azure Storage in bytes/second.", 0L);
    private final MutableGaugeLong maximumDownloadBytesPerSecond = this.registry.newGauge("wasb_maximum_download_bytes_per_second", "The maximum download rate encountered to Azure Storage in bytes/second.", 0L);
    private final MutableCounterLong rawBytesUploaded = this.registry.newCounter("wasb_raw_bytes_uploaded", "Total number of raw bytes (including overhead) uploaded to Azure Storage.", 0L);
    private final MutableCounterLong rawBytesDownloaded = this.registry.newCounter("wasb_raw_bytes_downloaded", "Total number of raw bytes (including overhead) downloaded from Azure Storage.", 0L);
    private final MutableCounterLong clientErrors = this.registry.newCounter("wasb_client_errors", "Total number of client-side errors by WASB (excluding 404).", 0L);
    private final MutableCounterLong serverErrors = this.registry.newCounter("wasb_server_errors", "Total number of server-caused errors by WASB.", 0L);
    private final MutableGaugeLong averageBlockUploadLatencyMs;
    private final MutableGaugeLong averageBlockDownloadLatencyMs;
    private long currentMaximumUploadBytesPerSecond;
    private long currentMaximumDownloadBytesPerSecond;
    private static final int DEFAULT_LATENCY_ROLLING_AVERAGE_WINDOW = 5;
    private final RollingWindowAverage currentBlockUploadLatency;
    private final RollingWindowAverage currentBlockDownloadLatency;
    private UUID fileSystemInstanceId = UUID.randomUUID();

    public AzureFileSystemInstrumentation(Configuration conf) {
        this.registry.tag(METRIC_TAG_FILESYSTEM_ID, "A unique identifier for the file ", this.fileSystemInstanceId.toString());
        int rollingWindowSizeInSeconds = conf.getInt(KEY_ROLLING_WINDOW_SIZE, 5);
        this.averageBlockUploadLatencyMs = this.registry.newGauge(WASB_UPLOAD_LATENCY, String.format("The average latency in milliseconds of uploading a single block. The average latency is calculated over a %d-second rolling window.", rollingWindowSizeInSeconds), 0L);
        this.averageBlockDownloadLatencyMs = this.registry.newGauge(WASB_DOWNLOAD_LATENCY, String.format("The average latency in milliseconds of downloading a single block. The average latency is calculated over a %d-second rolling window.", rollingWindowSizeInSeconds), 0L);
        this.currentBlockUploadLatency = new RollingWindowAverage(rollingWindowSizeInSeconds * 1000);
        this.currentBlockDownloadLatency = new RollingWindowAverage(rollingWindowSizeInSeconds * 1000);
    }

    public UUID getFileSystemInstanceId() {
        return this.fileSystemInstanceId;
    }

    public MetricsInfo getMetricsRegistryInfo() {
        return this.registry.info();
    }

    public void setAccountName(String accountName) {
        this.registry.tag(METRIC_TAG_ACCOUNT_NAME, "Name of the Azure Storage account that these metrics are going against", accountName);
    }

    public void setContainerName(String containerName) {
        this.registry.tag(METRIC_TAG_CONTAINTER_NAME, "Name of the Azure Storage container that these metrics are going against", containerName);
    }

    public void webResponse() {
        this.numberOfWebResponses.incr();
        this.inMemoryNumberOfWebResponses.incrementAndGet();
    }

    public long getCurrentWebResponses() {
        return this.inMemoryNumberOfWebResponses.get();
    }

    public void fileCreated() {
        this.numberOfFilesCreated.incr();
    }

    public void fileDeleted() {
        this.numberOfFilesDeleted.incr();
    }

    public void directoryCreated() {
        this.numberOfDirectoriesCreated.incr();
    }

    public void directoryDeleted() {
        this.numberOfDirectoriesDeleted.incr();
    }

    public void updateBytesWrittenInLastSecond(long currentBytesWritten) {
        this.bytesWrittenInLastSecond.set(currentBytesWritten);
    }

    public void updateBytesReadInLastSecond(long currentBytesRead) {
        this.bytesReadInLastSecond.set(currentBytesRead);
    }

    public synchronized void currentUploadBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond > this.currentMaximumUploadBytesPerSecond) {
            this.currentMaximumUploadBytesPerSecond = bytesPerSecond;
            this.maximumUploadBytesPerSecond.set(bytesPerSecond);
        }
    }

    public synchronized void currentDownloadBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond > this.currentMaximumDownloadBytesPerSecond) {
            this.currentMaximumDownloadBytesPerSecond = bytesPerSecond;
            this.maximumDownloadBytesPerSecond.set(bytesPerSecond);
        }
    }

    public void rawBytesUploaded(long numberOfBytes) {
        this.rawBytesUploaded.incr(numberOfBytes);
    }

    public void rawBytesDownloaded(long numberOfBytes) {
        this.rawBytesDownloaded.incr(numberOfBytes);
    }

    public void blockUploaded(long latency) {
        this.currentBlockUploadLatency.addPoint(latency);
    }

    public void blockDownloaded(long latency) {
        this.currentBlockDownloadLatency.addPoint(latency);
    }

    public void clientErrorEncountered() {
        this.clientErrors.incr();
    }

    public void serverErrorEncountered() {
        this.serverErrors.incr();
    }

    public long getBlockUploadLatency() {
        return this.currentBlockUploadLatency.getCurrentAverage();
    }

    public long getBlockDownloadLatency() {
        return this.currentBlockDownloadLatency.getCurrentAverage();
    }

    public long getCurrentMaximumUploadBandwidth() {
        return this.currentMaximumUploadBytesPerSecond;
    }

    public long getCurrentMaximumDownloadBandwidth() {
        return this.currentMaximumDownloadBytesPerSecond;
    }

    @Override
    public void getMetrics(MetricsCollector builder, boolean all) {
        this.averageBlockDownloadLatencyMs.set(this.currentBlockDownloadLatency.getCurrentAverage());
        this.averageBlockUploadLatencyMs.set(this.currentBlockUploadLatency.getCurrentAverage());
        this.registry.snapshot(builder.addRecord(this.registry.info().name()), true);
    }
}

