/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import org.apache.flink.fs.azure.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.azure.shaded.org.apache.http.Header;
import org.apache.flink.fs.azure.shaded.org.apache.http.HttpResponse;
import org.apache.flink.fs.azure.shaded.org.apache.http.NameValuePair;
import org.apache.flink.fs.azure.shaded.org.apache.http.StatusLine;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.HttpClient;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.methods.HttpPut;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.methods.HttpUriRequest;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.utils.URIBuilder;
import org.apache.flink.fs.azure.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.WasbRemoteCallException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WasbRemoteCallHelper {
    public static final Logger LOG = LoggerFactory.getLogger(WasbRemoteCallHelper.class);
    public static final int REMOTE_CALL_SUCCESS_CODE = 0;
    private static final String APPLICATION_JSON = "application/json";
    private static final int MAX_CONTENT_LENGTH = 1024;
    private HttpClient client = null;
    private Random random = new Random();
    private RetryPolicy retryPolicy = null;

    public WasbRemoteCallHelper(RetryPolicy retryPolicy) {
        this.client = HttpClientBuilder.create().build();
        this.retryPolicy = retryPolicy;
    }

    @VisibleForTesting
    public void updateHttpClient(HttpClient client) {
        this.client = client;
    }

    public String makeRemoteRequest(String[] urls, String path, List<NameValuePair> queryParams, String httpMethod) throws IOException {
        return this.retryableRequest(urls, path, queryParams, httpMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String retryableRequest(String[] urls, String path, List<NameValuePair> queryParams, String httpMethod) throws IOException {
        int index;
        HttpResponse response = null;
        HttpUriRequest httpRequest = null;
        int indexOfLocalUrl = -1;
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toLowerCase().startsWith("https://localhost:") && !urls[i].toLowerCase().startsWith("http://localhost:")) continue;
            indexOfLocalUrl = i;
        }
        boolean requiresNewAuth = false;
        int retry = 0;
        int n = index = indexOfLocalUrl != -1 ? indexOfLocalUrl : this.random.nextInt(urls.length);
        while (true) {
            if (index >= urls.length) {
                index %= urls.length;
            }
            if (indexOfLocalUrl != -1 && retry == 1 && (index = (index + this.random.nextInt(urls.length)) % urls.length) == indexOfLocalUrl) {
                index = (index + 1) % urls.length;
            }
            try {
                httpRequest = this.getHttpRequest(urls, path, queryParams, index, httpMethod, requiresNewAuth);
                httpRequest.setHeader("Accept", APPLICATION_JSON);
                response = this.client.execute(httpRequest);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine == null || statusLine.getStatusCode() != 200) {
                    requiresNewAuth = statusLine == null || statusLine.getStatusCode() == 401;
                    throw new WasbRemoteCallException(httpRequest.getURI().toString() + ":" + (statusLine != null ? statusLine.toString() : "NULL"));
                }
                requiresNewAuth = false;
                Header contentTypeHeader = response.getFirstHeader("Content-Type");
                if (contentTypeHeader == null || !APPLICATION_JSON.equals(contentTypeHeader.getValue())) {
                    throw new WasbRemoteCallException(httpRequest.getURI().toString() + ":Content-Type mismatch: expected: " + APPLICATION_JSON + ", got " + (contentTypeHeader != null ? contentTypeHeader.getValue() : "NULL"));
                }
                Header contentLengthHeader = response.getFirstHeader("Content-Length");
                if (contentLengthHeader == null) {
                    throw new WasbRemoteCallException(httpRequest.getURI().toString() + ":Content-Length header missing");
                }
                try {
                    if (Integer.parseInt(contentLengthHeader.getValue()) > 1024) {
                        throw new WasbRemoteCallException(httpRequest.getURI().toString() + ":Content-Length:" + contentLengthHeader.getValue() + "exceeded max:" + 1024);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new WasbRemoteCallException(httpRequest.getURI().toString() + ":Invalid Content-Length value :" + contentLengthHeader.getValue());
                }
                StringBuilder responseBody = new StringBuilder();
                try (BufferedReader rd = null;){
                    rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
                    String responseLine = "";
                    while ((responseLine = rd.readLine()) != null) {
                        responseBody.append(responseLine);
                    }
                }
                return responseBody.toString();
            }
            catch (URISyntaxException uriSyntaxEx) {
                throw new WasbRemoteCallException("Encountered URISyntaxException while building the HttpGetRequest to remote service", uriSyntaxEx);
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                try {
                    this.shouldRetry(e, retry, httpRequest != null ? httpRequest.getURI().toString() : urls[index]);
                }
                catch (IOException ioex) {
                    String message = "Encountered error while making remote call to " + String.join((CharSequence)",", urls) + " retried " + retry + " time(s).";
                    LOG.error(message, (Throwable)ioex);
                    throw new WasbRemoteCallException(message, ioex);
                }
                ++retry;
                ++index;
                continue;
            }
            break;
        }
    }

    protected HttpUriRequest getHttpRequest(String[] urls, String path, List<NameValuePair> queryParams, int urlIndex, String httpMethod, boolean requiresNewAuth) throws URISyntaxException, IOException {
        URIBuilder uriBuilder = null;
        uriBuilder = new URIBuilder(urls[urlIndex]).setPath(path).setParameters(queryParams);
        if (uriBuilder.getHost().equals("localhost")) {
            uriBuilder.setHost(InetAddress.getLocalHost().getCanonicalHostName());
        }
        HttpRequestBase httpUriRequest = null;
        switch (httpMethod) {
            case "PUT": {
                httpUriRequest = new HttpPut(uriBuilder.build());
                break;
            }
            case "POST": {
                httpUriRequest = new HttpPost(uriBuilder.build());
                break;
            }
            default: {
                httpUriRequest = new HttpGet(uriBuilder.build());
            }
        }
        return httpUriRequest;
    }

    private void shouldRetry(IOException ioe, int retry, String url) throws IOException {
        String authenticationExceptionMessage = "Authentication Failed ";
        if (ioe instanceof WasbRemoteCallException && ioe.getMessage().equals(authenticationExceptionMessage)) {
            throw ioe;
        }
        try {
            boolean isFailoverAndRetry;
            RetryPolicy.RetryAction a = this.retryPolicy != null ? this.retryPolicy.shouldRetry(ioe, retry, 0, true) : RetryPolicy.RetryAction.FAIL;
            boolean isRetry = a.action == RetryPolicy.RetryAction.RetryDecision.RETRY;
            boolean bl = isFailoverAndRetry = a.action == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY;
            if (isRetry || isFailoverAndRetry) {
                LOG.debug("Retrying connect to Remote service:{}. Already tried {} time(s); retry policy is {}, delay {}ms.", new Object[]{url, retry, this.retryPolicy, a.delayMillis});
                Thread.sleep(a.delayMillis);
                return;
            }
        }
        catch (InterruptedIOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            LOG.warn("Original exception is ", (Throwable)ioe);
            throw new WasbRemoteCallException(e.getMessage(), e);
        }
        LOG.debug("Not retrying anymore, already retried the urls {} time(s)", (Object)retry);
        throw new WasbRemoteCallException(url + ":Encountered IOException while making remote call", ioe);
    }
}

