/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import java.nio.ByteBuffer;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobRequestOptions;

final class PageBlobFormatHelpers {
    public static final short PAGE_SIZE = 512;
    public static final short PAGE_HEADER_SIZE = 2;
    public static final short PAGE_DATA_SIZE = 510;

    private PageBlobFormatHelpers() {
    }

    public static byte[] fromShort(short s) {
        return ByteBuffer.allocate(2).putShort(s).array();
    }

    public static short toShort(byte firstByte, byte secondByte) {
        return ByteBuffer.wrap(new byte[]{firstByte, secondByte}).getShort();
    }

    public static BlobRequestOptions withMD5Checking() {
        BlobRequestOptions options = new BlobRequestOptions();
        options.setUseTransactionalContentMD5(true);
        return options;
    }
}

