/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.CloudStorageAccount;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.SharedAccessAccountPermissions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.SharedAccessAccountPolicy;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.SharedAccessAccountResourceType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.SharedAccessAccountService;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentials;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobClient;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobContainer;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlockBlob;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.CachedSASKeyEntry;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.CachingAuthorizer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.SASKeyGenerationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.SASKeyGeneratorImpl;

public class LocalSASKeyGeneratorImpl
extends SASKeyGeneratorImpl {
    private Map<String, CloudStorageAccount> storageAccountMap = new HashMap<String, CloudStorageAccount>();
    private CachingAuthorizer<CachedSASKeyEntry, URI> cache = new CachingAuthorizer(this.getSasKeyExpiryPeriod(), "SASKEY");
    private static final int HOURS_IN_DAY = 24;

    public LocalSASKeyGeneratorImpl(Configuration conf) {
        super(conf);
        this.cache.init(conf);
    }

    @Override
    public URI getContainerSASUri(String accountName, String container) throws SASKeyGenerationException {
        try {
            CachedSASKeyEntry cacheKey = new CachedSASKeyEntry(accountName, container, "/");
            URI cacheResult = this.cache.get(cacheKey);
            if (cacheResult != null) {
                return cacheResult;
            }
            CloudStorageAccount account = this.getSASKeyBasedStorageAccountInstance(accountName);
            CloudBlobClient client = account.createCloudBlobClient();
            URI sasKey = client.getCredentials().transformUri(client.getContainerReference(container).getUri());
            this.cache.put(cacheKey, sasKey);
            return sasKey;
        }
        catch (StorageException stoEx) {
            throw new SASKeyGenerationException("Encountered StorageException while generating SAS Key for container " + container + " inside storage account " + accountName, stoEx);
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException while generating SAS Key for container " + container + " inside storage account " + accountName, uriSyntaxEx);
        }
    }

    private CloudStorageAccount getSASKeyBasedStorageAccountInstance(String accountName) throws SASKeyGenerationException {
        try {
            String accountNameWithoutDomain = this.getAccountNameWithoutDomain(accountName);
            CloudStorageAccount account = this.getStorageAccountInstance(accountNameWithoutDomain, AzureNativeFileSystemStore.getAccountKeyFromConfiguration(accountName, this.getConf()));
            return new CloudStorageAccount((StorageCredentials)new StorageCredentialsSharedAccessSignature(account.generateSharedAccessSignature(this.getDefaultAccountAccessPolicy())), false, account.getEndpointSuffix(), accountNameWithoutDomain);
        }
        catch (KeyProviderException keyProviderEx) {
            throw new SASKeyGenerationException("Encountered KeyProviderException while retrieving Storage key from configuration for account " + accountName, keyProviderEx);
        }
        catch (InvalidKeyException invalidKeyEx) {
            throw new SASKeyGenerationException("Encoutered InvalidKeyException while generating Account level SAS key for account" + accountName, invalidKeyEx);
        }
        catch (StorageException storeEx) {
            throw new SASKeyGenerationException("Encoutered StorageException while generating Account level SAS key for account" + accountName, storeEx);
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException for account " + accountName, uriSyntaxEx);
        }
    }

    @Override
    public URI getRelativeBlobSASUri(String accountName, String container, String relativePath) throws SASKeyGenerationException {
        CloudBlobContainer sc = null;
        CloudBlobClient client = null;
        CachedSASKeyEntry cacheKey = null;
        try {
            cacheKey = new CachedSASKeyEntry(accountName, container, relativePath);
            URI cacheResult = this.cache.get(cacheKey);
            if (cacheResult != null) {
                return cacheResult;
            }
            CloudStorageAccount account = this.getSASKeyBasedStorageAccountInstance(accountName);
            client = account.createCloudBlobClient();
            sc = client.getContainerReference(container);
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException while getting container references for container " + container + " inside storage account : " + accountName, uriSyntaxEx);
        }
        catch (StorageException stoEx) {
            throw new SASKeyGenerationException("Encountered StorageException while getting  container references for container " + container + " inside storage account : " + accountName, stoEx);
        }
        CloudBlockBlob blob = null;
        try {
            blob = sc.getBlockBlobReference(relativePath);
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException while getting Block Blob references for container " + container + " inside storage account : " + accountName, uriSyntaxEx);
        }
        catch (StorageException stoEx) {
            throw new SASKeyGenerationException("Encountered StorageException while getting Block Blob references for container " + container + " inside storage account : " + accountName, stoEx);
        }
        try {
            URI sasKey = client.getCredentials().transformUri(blob.getUri());
            this.cache.put(cacheKey, sasKey);
            return sasKey;
        }
        catch (StorageException stoEx) {
            throw new SASKeyGenerationException("Encountered StorageException while generating SAS key for Blob: " + relativePath + " inside container : " + container + " in Storage Account : " + accountName, stoEx);
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException while generating SAS key for Blob: " + relativePath + " inside container: " + container + " in Storage Account : " + accountName, uriSyntaxEx);
        }
    }

    private CloudStorageAccount getStorageAccountInstance(String accountName, String accountKey) throws SASKeyGenerationException {
        if (!this.storageAccountMap.containsKey(accountName)) {
            CloudStorageAccount account = null;
            try {
                account = new CloudStorageAccount(new StorageCredentialsAccountAndKey(accountName, accountKey));
            }
            catch (URISyntaxException uriSyntaxEx) {
                throw new SASKeyGenerationException("Encountered URISyntaxException for account " + accountName, uriSyntaxEx);
            }
            this.storageAccountMap.put(accountName, account);
        }
        return this.storageAccountMap.get(accountName);
    }

    private String getAccountNameWithoutDomain(String fullAccountName) {
        StringTokenizer tokenizer = new StringTokenizer(fullAccountName, ".");
        return tokenizer.nextToken();
    }

    private SharedAccessAccountPolicy getDefaultAccountAccessPolicy() {
        SharedAccessAccountPolicy ap = new SharedAccessAccountPolicy();
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date());
        ((Calendar)cal).add(10, (int)this.getSasKeyExpiryPeriod() * 24);
        ap.setSharedAccessExpiryTime(cal.getTime());
        ap.setPermissions(this.getDefaultAccoutSASKeyPermissions());
        ap.setResourceTypes(EnumSet.of(SharedAccessAccountResourceType.CONTAINER, SharedAccessAccountResourceType.OBJECT));
        ap.setServices(EnumSet.of(SharedAccessAccountService.BLOB));
        return ap;
    }

    private EnumSet<SharedAccessAccountPermissions> getDefaultAccoutSASKeyPermissions() {
        return EnumSet.of(SharedAccessAccountPermissions.ADD, new SharedAccessAccountPermissions[]{SharedAccessAccountPermissions.CREATE, SharedAccessAccountPermissions.DELETE, SharedAccessAccountPermissions.LIST, SharedAccessAccountPermissions.READ, SharedAccessAccountPermissions.UPDATE, SharedAccessAccountPermissions.WRITE});
    }
}

