/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.CryptoCodec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.Decryptor;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.Encryptor;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key.KeyProviderExtension;

@InterfaceAudience.Private
public class KeyProviderCryptoExtension
extends KeyProviderExtension<CryptoExtension> {
    public static final String EEK = "EEK";
    public static final String EK = "EK";

    protected KeyProviderCryptoExtension(KeyProvider keyProvider, CryptoExtension extension) {
        super(keyProvider, extension);
    }

    public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        ((CryptoExtension)this.getExtension()).warmUpEncryptedKeys(keyNames);
    }

    public EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
        return ((CryptoExtension)this.getExtension()).generateEncryptedKey(encryptionKeyName);
    }

    public KeyProvider.KeyVersion decryptEncryptedKey(EncryptedKeyVersion encryptedKey) throws IOException, GeneralSecurityException {
        return ((CryptoExtension)this.getExtension()).decryptEncryptedKey(encryptedKey);
    }

    public EncryptedKeyVersion reencryptEncryptedKey(EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
        return ((CryptoExtension)this.getExtension()).reencryptEncryptedKey(ekv);
    }

    public void drain(String keyName) {
        ((CryptoExtension)this.getExtension()).drain(keyName);
    }

    public void reencryptEncryptedKeys(List<EncryptedKeyVersion> ekvs) throws IOException, GeneralSecurityException {
        ((CryptoExtension)this.getExtension()).reencryptEncryptedKeys(ekvs);
    }

    public static KeyProviderCryptoExtension createKeyProviderCryptoExtension(KeyProvider keyProvider) {
        CryptoExtension cryptoExtension = null;
        if (keyProvider instanceof CryptoExtension) {
            cryptoExtension = (CryptoExtension)((Object)keyProvider);
        } else if (keyProvider instanceof KeyProviderExtension && ((KeyProviderExtension)keyProvider).getKeyProvider() instanceof CryptoExtension) {
            KeyProviderExtension keyProviderExtension = (KeyProviderExtension)keyProvider;
            cryptoExtension = (CryptoExtension)((Object)keyProviderExtension.getKeyProvider());
        } else {
            cryptoExtension = new DefaultCryptoExtension(keyProvider);
        }
        return new KeyProviderCryptoExtension(keyProvider, cryptoExtension);
    }

    @Override
    public void close() throws IOException {
        KeyProvider provider = this.getKeyProvider();
        if (provider != null && provider != this) {
            provider.close();
        }
    }

    private static class DefaultCryptoExtension
    implements CryptoExtension {
        private final KeyProvider keyProvider;
        private static final ThreadLocal<SecureRandom> RANDOM = new ThreadLocal<SecureRandom>(){

            @Override
            protected SecureRandom initialValue() {
                return new SecureRandom();
            }
        };

        private DefaultCryptoExtension(KeyProvider keyProvider) {
            this.keyProvider = keyProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            KeyProvider.KeyVersion encryptionKey = this.keyProvider.getCurrentKey(encryptionKeyName);
            Preconditions.checkNotNull(encryptionKey, "No KeyVersion exists for key '%s' ", encryptionKeyName);
            try (CryptoCodec cc = CryptoCodec.getInstance(this.keyProvider.getConf());){
                byte[] newKey = new byte[encryptionKey.getMaterial().length];
                cc.generateSecureRandom(newKey);
                byte[] iv = new byte[cc.getCipherSuite().getAlgorithmBlockSize()];
                cc.generateSecureRandom(iv);
                Encryptor encryptor = cc.createEncryptor();
                EncryptedKeyVersion encryptedKeyVersion = this.generateEncryptedKey(encryptor, encryptionKey, newKey, iv);
                return encryptedKeyVersion;
            }
        }

        private EncryptedKeyVersion generateEncryptedKey(Encryptor encryptor, KeyProvider.KeyVersion encryptionKey, byte[] key, byte[] iv) throws IOException, GeneralSecurityException {
            byte[] encryptionIV = EncryptedKeyVersion.deriveIV(iv);
            encryptor.init(encryptionKey.getMaterial(), encryptionIV);
            int keyLen = key.length;
            ByteBuffer bbIn = ByteBuffer.allocateDirect(keyLen);
            ByteBuffer bbOut = ByteBuffer.allocateDirect(keyLen);
            bbIn.put(key);
            bbIn.flip();
            encryptor.encrypt(bbIn, bbOut);
            bbOut.flip();
            byte[] encryptedKey = new byte[keyLen];
            bbOut.get(encryptedKey);
            return new EncryptedKeyVersion(encryptionKey.getName(), encryptionKey.getVersionName(), iv, new KeyProvider.KeyVersion(encryptionKey.getName(), KeyProviderCryptoExtension.EEK, encryptedKey));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EncryptedKeyVersion reencryptEncryptedKey(EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
            String ekName = ekv.getEncryptionKeyName();
            KeyProvider.KeyVersion ekNow = this.keyProvider.getCurrentKey(ekName);
            Preconditions.checkNotNull(ekNow, "KeyVersion name '%s' does not exist", ekName);
            Preconditions.checkArgument(ekv.getEncryptedKeyVersion().getVersionName().equals(KeyProviderCryptoExtension.EEK), "encryptedKey version name must be '%s', but found '%s'", KeyProviderCryptoExtension.EEK, ekv.getEncryptedKeyVersion().getVersionName());
            if (ekv.getEncryptedKeyVersion().equals(ekNow)) {
                return ekv;
            }
            KeyProvider.KeyVersion dek = this.decryptEncryptedKey(ekv);
            try (CryptoCodec cc = CryptoCodec.getInstance(this.keyProvider.getConf());){
                Encryptor encryptor = cc.createEncryptor();
                EncryptedKeyVersion encryptedKeyVersion = this.generateEncryptedKey(encryptor, ekNow, dek.getMaterial(), ekv.getEncryptedKeyIv());
                return encryptedKeyVersion;
            }
        }

        @Override
        public void reencryptEncryptedKeys(List<EncryptedKeyVersion> ekvs) throws IOException, GeneralSecurityException {
            Preconditions.checkNotNull(ekvs, "Input list is null");
            KeyProvider.KeyVersion ekNow = null;
            Decryptor decryptor = null;
            Encryptor encryptor = null;
            try (CryptoCodec cc = CryptoCodec.getInstance(this.keyProvider.getConf());){
                decryptor = cc.createDecryptor();
                encryptor = cc.createEncryptor();
                ListIterator<EncryptedKeyVersion> iter = ekvs.listIterator();
                while (iter.hasNext()) {
                    EncryptedKeyVersion ekv = iter.next();
                    Preconditions.checkNotNull(ekv, "EncryptedKeyVersion is null");
                    String ekName = ekv.getEncryptionKeyName();
                    Preconditions.checkNotNull(ekName, "Key name is null");
                    Preconditions.checkNotNull(ekv.getEncryptedKeyVersion(), "EncryptedKeyVersion is null");
                    Preconditions.checkArgument(ekv.getEncryptedKeyVersion().getVersionName().equals(KeyProviderCryptoExtension.EEK), "encryptedKey version name must be '%s', but found '%s'", KeyProviderCryptoExtension.EEK, ekv.getEncryptedKeyVersion().getVersionName());
                    if (ekNow == null) {
                        ekNow = this.keyProvider.getCurrentKey(ekName);
                        Preconditions.checkNotNull(ekNow, "Key name '%s' does not exist", ekName);
                    } else {
                        Preconditions.checkArgument(ekNow.getName().equals(ekName), "All keys must have the same key name. Expected '%s' but found '%s'", ekNow.getName(), ekName);
                    }
                    String encryptionKeyVersionName = ekv.getEncryptionKeyVersionName();
                    KeyProvider.KeyVersion encryptionKey = this.keyProvider.getKeyVersion(encryptionKeyVersionName);
                    Preconditions.checkNotNull(encryptionKey, "KeyVersion name '%s' does not exist", encryptionKeyVersionName);
                    if (encryptionKey.equals(ekNow)) continue;
                    KeyProvider.KeyVersion ek = this.decryptEncryptedKey(decryptor, encryptionKey, ekv);
                    iter.set(this.generateEncryptedKey(encryptor, ekNow, ek.getMaterial(), ekv.getEncryptedKeyIv()));
                }
            }
        }

        private KeyProvider.KeyVersion decryptEncryptedKey(Decryptor decryptor, KeyProvider.KeyVersion encryptionKey, EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            byte[] encryptionIV = EncryptedKeyVersion.deriveIV(encryptedKeyVersion.getEncryptedKeyIv());
            decryptor.init(encryptionKey.getMaterial(), encryptionIV);
            KeyProvider.KeyVersion encryptedKV = encryptedKeyVersion.getEncryptedKeyVersion();
            int keyLen = encryptedKV.getMaterial().length;
            ByteBuffer bbIn = ByteBuffer.allocateDirect(keyLen);
            ByteBuffer bbOut = ByteBuffer.allocateDirect(keyLen);
            bbIn.put(encryptedKV.getMaterial());
            bbIn.flip();
            decryptor.decrypt(bbIn, bbOut);
            bbOut.flip();
            byte[] decryptedKey = new byte[keyLen];
            bbOut.get(decryptedKey);
            return new KeyProvider.KeyVersion(encryptionKey.getName(), KeyProviderCryptoExtension.EK, decryptedKey);
        }

        @Override
        public KeyProvider.KeyVersion decryptEncryptedKey(EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            String encryptionKeyVersionName = encryptedKeyVersion.getEncryptionKeyVersionName();
            KeyProvider.KeyVersion encryptionKey = this.keyProvider.getKeyVersion(encryptionKeyVersionName);
            Preconditions.checkNotNull(encryptionKey, "KeyVersion name '%s' does not exist", encryptionKeyVersionName);
            Preconditions.checkArgument(encryptedKeyVersion.getEncryptedKeyVersion().getVersionName().equals(KeyProviderCryptoExtension.EEK), "encryptedKey version name must be '%s', but found '%s'", KeyProviderCryptoExtension.EEK, encryptedKeyVersion.getEncryptedKeyVersion().getVersionName());
            try (CryptoCodec cc = CryptoCodec.getInstance(this.keyProvider.getConf());){
                Decryptor decryptor = cc.createDecryptor();
                KeyProvider.KeyVersion keyVersion = this.decryptEncryptedKey(decryptor, encryptionKey, encryptedKeyVersion);
                return keyVersion;
            }
        }

        @Override
        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        }

        @Override
        public void drain(String keyName) {
        }
    }

    public static interface CryptoExtension
    extends KeyProviderExtension.Extension {
        public void warmUpEncryptedKeys(String ... var1) throws IOException;

        public void drain(String var1);

        public EncryptedKeyVersion generateEncryptedKey(String var1) throws IOException, GeneralSecurityException;

        public KeyProvider.KeyVersion decryptEncryptedKey(EncryptedKeyVersion var1) throws IOException, GeneralSecurityException;

        public EncryptedKeyVersion reencryptEncryptedKey(EncryptedKeyVersion var1) throws IOException, GeneralSecurityException;

        public void reencryptEncryptedKeys(List<EncryptedKeyVersion> var1) throws IOException, GeneralSecurityException;
    }

    public static class EncryptedKeyVersion {
        private String encryptionKeyName;
        private String encryptionKeyVersionName;
        private byte[] encryptedKeyIv;
        private KeyProvider.KeyVersion encryptedKeyVersion;

        protected EncryptedKeyVersion(String keyName, String encryptionKeyVersionName, byte[] encryptedKeyIv, KeyProvider.KeyVersion encryptedKeyVersion) {
            this.encryptionKeyName = keyName == null ? null : keyName.intern();
            this.encryptionKeyVersionName = encryptionKeyVersionName == null ? null : encryptionKeyVersionName.intern();
            this.encryptedKeyIv = encryptedKeyIv;
            this.encryptedKeyVersion = encryptedKeyVersion;
        }

        public static EncryptedKeyVersion createForDecryption(String keyName, String encryptionKeyVersionName, byte[] encryptedKeyIv, byte[] encryptedKeyMaterial) {
            KeyProvider.KeyVersion encryptedKeyVersion = new KeyProvider.KeyVersion(null, KeyProviderCryptoExtension.EEK, encryptedKeyMaterial);
            return new EncryptedKeyVersion(keyName, encryptionKeyVersionName, encryptedKeyIv, encryptedKeyVersion);
        }

        public String getEncryptionKeyName() {
            return this.encryptionKeyName;
        }

        public String getEncryptionKeyVersionName() {
            return this.encryptionKeyVersionName;
        }

        public byte[] getEncryptedKeyIv() {
            return this.encryptedKeyIv;
        }

        public KeyProvider.KeyVersion getEncryptedKeyVersion() {
            return this.encryptedKeyVersion;
        }

        protected static byte[] deriveIV(byte[] encryptedKeyIV) {
            byte[] rIv = new byte[encryptedKeyIV.length];
            for (int i = 0; i < encryptedKeyIV.length; ++i) {
                rIv[i] = (byte)(encryptedKeyIV[i] ^ 0xFF);
            }
            return rIv;
        }
    }
}

